# LinkBoostify - Digital Marketing Agency Website

A modern, professional digital marketing agency website built with PHP, inspired by premium agency designs.

## 🚀 Features

- **Modern Design**: Premium UI with gradients, animations, and glassmorphism
- **Responsive Layout**: Mobile-first design that works on all devices
- **Admin Panel**: Complete CMS for managing blogs, portfolio, and content
- **Blog System**: Full-featured blog with categories and publishing
- **Portfolio Showcase**: Display your work and projects
- **Contact Form**: Integrated contact form with email notifications
- **SEO Optimized**: Clean URLs and SEO-friendly structure
- **Fast Performance**: Lightweight and optimized code

## 📋 Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache/Nginx web server
- mod_rewrite enabled (for clean URLs)

## 🛠️ Installation

1. **Clone or download** this project to your web server directory

2. **Import the database**:
   - Open your browser and navigate to `http://localhost/linkboostify/setup.php`
   - This will automatically create the database and tables
   - **Delete `setup.php` after installation!**

3. **Configure the database** (if needed):
   - Edit `includes/config.php`
   - Update database credentials if different from defaults

4. **Set permissions**:
   ```bash
   chmod 755 uploads/
   ```

5. **Access the website**:
   - Frontend: `http://localhost/linkboostify/`
   - Admin Panel: `http://localhost/linkboostify/admin/`

## 🔐 Default Admin Credentials

- **Username**: `admin`
- **Password**: `admin123`

**⚠️ IMPORTANT**: Change these credentials immediately after first login!

## 📁 Project Structure

```
linkboostify/
├── admin/                  # Admin panel
│   ├── index.php          # Dashboard
│   ├── login.php          # Admin login
│   ├── blogs.php          # Blog management
│   ├── portfolio.php      # Portfolio management
│   └── logout.php         # Logout
├── assets/
│   ├── css/
│   │   └── style.css      # Main stylesheet
│   ├── js/
│   │   └── main.js        # JavaScript
│   └── images/            # Images
├── includes/
│   ├── config.php         # Configuration
│   ├── functions.php      # Helper functions
│   ├── header.php         # Header component
│   └── footer.php         # Footer component
├── uploads/               # User uploads
├── index.php              # Homepage
├── about-us.php           # About page
├── blog.php               # Blog listing
├── contact-us.php         # Contact page
├── portfolio.php          # Portfolio page
└── setup.php              # Database setup (delete after use)
```

## 🎨 Customization

### Change Colors

Edit `assets/css/style.css` and modify the CSS variables:

```css
:root {
    --primary-color: #667eea;
    --secondary-color: #f5576c;
    /* ... more variables */
}
```

### Update Site Information

Edit `includes/config.php`:

```php
define('SITE_NAME', 'Your Company Name');
define('SITE_EMAIL', 'your@email.com');
define('SITE_PHONE', '+1234567890');
```

## 📝 Admin Panel Features

- **Dashboard**: Overview of all content
- **Blog Management**: Create, edit, delete blog posts
- **Portfolio Management**: Showcase your work
- **Contact Submissions**: View messages from contact form
- **Settings**: Update site configuration

## 🔒 Security Features

- Password hashing with PHP password_hash()
- SQL injection protection with PDO prepared statements
- XSS protection with htmlspecialchars()
- Session-based authentication
- Admin area protection

## 📱 Pages Included

1. **Home** - Hero section, services, stats, blog preview
2. **About Us** - Company information
3. **Services**:
   - SEO & PR Links
   - Social Media Marketing
   - Website Development
   - Graphics Design
   - Online Reputation Management
4. **Portfolio** - Work showcase
5. **Blog** - Articles and insights
6. **Contact Us** - Contact form

## 🌟 Technologies Used

- **Backend**: PHP 7.4+
- **Database**: MySQL
- **Frontend**: HTML5, CSS3, JavaScript
- **Icons**: Font Awesome 6
- **Fonts**: Google Fonts (Inter)

## 📧 Support

For support, email: info@linkboostify.com

## 📄 License

This project is open source and available for personal and commercial use.

## 🙏 Credits

Design inspired by modern digital marketing agencies.
Built with ❤️ by LinkBoostify Team

---

**Happy Marketing! 🚀**
