<?php
session_start();
require_once 'includes/config.php';
require_once 'includes/functions.php';

$page_title = "About Us - LinkBoostify";
$page_description = "LinkBoostify is a specialized link building agency helping businesses achieve top search rankings through ethical, high-quality backlink strategies.";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <meta name="description" content="<?php echo $page_description; ?>">
    
    <?php include 'includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <!-- Hero Section -->
    <section class="page-header" style="padding: 140px 0 80px; background: var(--dark-bg); margin-top: 70px;">
        <div class="container">
            <div class="section-header" style="text-align: center;">
                <h1 class="section-title" style="font-size: clamp(40px, 5vw, 64px); margin-bottom: 20px;">
                    Building Authority Through <span class="text-orange">Strategic Link Building</span>
                </h1>
                <p style="color: var(--text-secondary); max-width: 800px; margin: 0 auto; font-size: 18px; line-height: 1.8;">
                    LinkBoostify is a results-driven link building agency dedicated to helping businesses achieve top search rankings through ethical, high-quality backlink strategies. We work with startups, entrepreneurs, and growing companies to turn SEO challenges into measurable success.
                </p>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section style="padding: 60px 0; background: var(--dark-card);">
        <div class="container">
            <div class="stats-grid" style="grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 40px;">
                <div class="stat-card" style="text-align: center;">
                    <h2 style="font-size: 48px; font-weight: 800; color: var(--primary-color); margin-bottom: 10px;">8+</h2>
                    <p style="color: var(--text-secondary); font-size: 16px;">Years of Experience<br>Link Building Excellence</p>
                </div>
                <div class="stat-card" style="text-align: center;">
                    <h2 style="font-size: 48px; font-weight: 800; color: var(--primary-color); margin-bottom: 10px;">2500+</h2>
                    <p style="color: var(--text-secondary); font-size: 16px;">Successful Campaigns<br>Across Industries</p>
                </div>
                <div class="stat-card" style="text-align: center;">
                    <h2 style="font-size: 48px; font-weight: 800; color: var(--primary-color); margin-bottom: 10px;">50K+</h2>
                    <p style="color: var(--text-secondary); font-size: 16px;">Quality Backlinks<br>Built & Delivered</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Who We Are Section with Image -->
    <section style="padding: var(--spacing-xxl) 0; background: var(--dark-bg);">
        <div class="container">
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: start;">
                <div>
                    <h2 class="section-title" style="margin-bottom: 30px; font-size: 48px; color: var(--primary-color);">Who We Are</h2>
                    <p style="color: var(--text-secondary); font-size: 18px; line-height: 1.8; margin-bottom: 20px;">
                        LinkBoostify was built on the belief that link building should be strategic, transparent, and impactful. We combine outreach expertise, content quality, and SEO knowledge to deliver tailored backlink solutions that help brands dominate search results in competitive niches.
                    </p>
                    <p style="color: var(--text-secondary); font-size: 18px; line-height: 1.8; margin-bottom: 40px;">
                        We don't chase shortcuts — we build <strong style="color: var(--text-primary);">sustainable SEO growth</strong> through white-hat link building techniques.
                    </p>
                    
                    <!-- Mission & Vision Cards -->
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                        <div style="background: var(--dark-card); padding: 30px; border-radius: 12px; border: 1px solid rgba(255, 107, 53, 0.1);">
                            <div style="width: 50px; height: 50px; background: rgba(255, 107, 53, 0.1); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-bottom: 20px;">
                                <i class="fas fa-bullseye" style="color: var(--primary-color); font-size: 24px;"></i>
                            </div>
                            <h3 style="margin-bottom: 15px; font-size: 20px; color: var(--text-primary);">Our Mission</h3>
                            <p style="color: var(--text-secondary); line-height: 1.7; font-size: 15px;">
                                To empower businesses with smart link building strategies that drive rankings, traffic, and authority — while delivering measurable results and lasting SEO value.
                            </p>
                        </div>
                        
                        <div style="background: var(--dark-card); padding: 30px; border-radius: 12px; border: 1px solid rgba(255, 107, 53, 0.1);">
                            <div style="width: 50px; height: 50px; background: rgba(255, 107, 53, 0.1); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-bottom: 20px;">
                                <i class="fas fa-eye" style="color: var(--primary-color); font-size: 24px;"></i>
                            </div>
                            <h3 style="margin-bottom: 15px; font-size: 20px; color: var(--text-primary);">Our Vision</h3>
                            <p style="color: var(--text-secondary); line-height: 1.7; font-size: 15px;">
                                To become the most trusted link building partner for brands worldwide by consistently delivering innovative, ethical, and performance-focused backlink solutions.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="image-anime">
                    <img src="assets/images/about-work.png" alt="Link Building Team" style="width: 100%; height: auto; border-radius: 12px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);" loading="lazy" decoding="async">
                </div>
            </div>
        </div>
    </section>

    <!-- What We Do Section -->
    <section style="padding: var(--spacing-xxl) 0; background: var(--dark-bg);">
        <div class="container">
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 80px; align-items: center;">
                <div>
                    <span style="color: var(--primary-color); font-size: 14px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; display: flex; align-items: center; gap: 8px; margin-bottom: 20px;">
                        <i class="fas fa-circle" style="font-size: 8px;"></i> WHAT WE DO
                    </span>
                    
                    <h2 style="font-size: 48px; font-weight: 800; line-height: 1.2; margin-bottom: 30px; color: var(--text-primary);">
                        Brands through strategic <span style="color: var(--primary-color);">What We Do</span> link building
                    </h2>
                    
                    <p style="color: var(--text-secondary); font-size: 18px; line-height: 1.8; margin-bottom: 20px;">
                        We offer a full range of link building and SEO services designed to strengthen your online presence:
                    </p>
                    
                    <p style="color: var(--text-secondary); font-size: 16px; line-height: 1.7; margin-bottom: 40px;">
                        Each service is carefully crafted to support your brand's visibility, credibility, and long-term growth.
                    </p>
                    
                    <!-- Services List -->
                    <div style="background: rgba(255, 107, 53, 0.05); border: 1px solid rgba(255, 107, 53, 0.1); border-radius: 12px; padding: 40px;">
                        <div style="display: flex; flex-direction: column; gap: 20px;">
                            <div style="display: flex; align-items: center; gap: 15px;">
                                <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                                <span style="color: var(--text-primary); font-size: 16px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px;">GUEST POSTING</span>
                            </div>
                            
                            <div style="display: flex; align-items: center; gap: 15px;">
                                <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                                <span style="color: var(--text-primary); font-size: 16px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px;">LINK INSERTION</span>
                            </div>
                            
                            <div style="display: flex; align-items: center; gap: 15px;">
                                <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                                <span style="color: var(--text-primary); font-size: 16px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px;">WIKIPEDIA BACKLINKS</span>
                            </div>
                            
                            <div style="display: flex; align-items: center; gap: 15px;">
                                <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                                <span style="color: var(--text-primary); font-size: 16px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px;">PBN BACKLINKS</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="image-anime">
                    <img src="assets/images/what-we-do.png" alt="SEO Professional Working" style="width: 100%; height: auto; border-radius: 12px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);" loading="lazy" decoding="async">
                </div>
            </div>
        </div>
    </section>




    <!-- Why Choose Us -->
    <section style="padding: var(--spacing-xxl) 0; background: var(--dark-bg);">
        <div class="container">
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 80px; align-items: start;">
                <!-- Left Side - Text Content -->
                <div>
                    <span style="color: var(--primary-color); font-size: 14px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; display: flex; align-items: center; gap: 8px; margin-bottom: 20px;">
                        <i class="fas fa-circle" style="font-size: 8px;"></i> HOW IT WORK
                    </span>
                    
                    <h2 style="font-size: 48px; font-weight: 800; line-height: 1.2; margin-bottom: 30px; color: var(--text-primary);">
                        Why Choose <span style="color: var(--primary-color);">LinkBoostify?</span>
                    </h2>
                    
                    <p style="color: var(--text-secondary); font-size: 18px; line-height: 1.8; margin-bottom: 20px;">
                        LinkBoostify was built on the belief that link building should be strategic, transparent, and impactful. We combine outreach expertise, content quality, and SEO knowledge to deliver tailored backlink solutions that help brands dominate search results in competitive niches.
                    </p>
                    
                    <p style="color: var(--text-secondary); font-size: 16px; line-height: 1.7; margin-bottom: 40px;">
                        We don't chase shortcuts — we build <strong style="color: var(--text-primary);">sustainable SEO growth</strong>.
                    </p>
                    
                    <a href="contact-us.php" class="btn btn-primary btn-large" style="display: inline-flex; align-items: center; gap: 10px;">
                        Get Started <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
                
                <!-- Right Side - Numbered Cards -->
                <div style="display: flex; flex-direction: column; gap: 20px;">
                    <!-- Card 01 -->
                    <div class="numbered-card">
                        <h3>White-Hat Link Building Only</h3>
                        <span class="card-number">01</span>
                    </div>
                    
                    <!-- Card 02 -->
                    <div class="numbered-card">
                        <h3>Transparent Reporting & Tracking</h3>
                        <span class="card-number">02</span>
                    </div>
                    
                    <!-- Card 03 -->
                    <div class="numbered-card">
                        <h3>Expert SEO Professionals</h3>
                        <span class="card-number">03</span>
                    </div>
                    
                    <!-- Card 04 -->
                    <div class="numbered-card">
                        <h3>Long-Term SEO Success</h3>
                        <span class="card-number">04</span>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container">
            <div class="cta-content">
                <h2>Ready to Dominate Search Rankings?</h2>
                <p>Let's build a powerful backlink strategy that drives real, measurable results for your business.</p>
                <a href="contact-us.php" class="btn btn-white btn-large">
                    Get Started Today <i class="fas fa-arrow-right"></i>
                </a>
            </div>
        </div>
    </section>

    <?php include 'includes/footer.php'; ?>
    <script src="assets/js/main.js"></script>
</body>
</html>
