<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/functions.php';

if (!isLoggedIn()) {
    redirectToLogin();
}

$message = '';
$error = '';

// Handle Delete Action
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    try {
        $stmt = $conn->prepare("DELETE FROM blogs WHERE id = ?");
        $stmt->execute([$id]);
        $message = "Blog post deleted successfully.";
    } catch(PDOException $e) {
        $error = "Error deleting post.";
    }
}

// Fetch Blogs
$blogs = [];
try {
    $stmt = $conn->query("SELECT * FROM blogs ORDER BY created_at DESC");
    $blogs = $stmt->fetchAll();
} catch(PDOException $e) {
    $error = "Error fetching blogs.";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Blogs - Admin</title>
    
    <?php include '../includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo time(); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body, html, a, button, input, textarea { cursor: auto !important; }
        .admin-layout { display: flex; min-height: 100vh; }
        .admin-sidebar { width: 260px; background: var(--dark-card); border-right: 1px solid var(--border-color); padding: var(--spacing-md); }
        .admin-content { flex: 1; padding: var(--spacing-lg); }
        .data-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        .data-table th, .data-table td { padding: 15px; text-align: left; border-bottom: 1px solid var(--border-color); }
        .data-table th { background: var(--dark-bg); font-weight: 600; color: var(--primary-color); }
        .status-badge { padding: 5px 10px; border-radius: 20px; font-size: 12px; font-weight: 600; }
        .status-published { background: rgba(46, 213, 115, 0.1); color: #2ed573; }
        .status-draft { background: rgba(255, 165, 2, 0.1); color: #ffa502; }
    </style>
</head>
<body>
    <div class="admin-layout">
        <aside class="admin-sidebar">
            <div class="logo" style="margin-bottom: var(--spacing-lg); font-size: 24px; font-weight: 800; color: var(--primary-color);">LinkBoostify</div>
            <nav style="display: flex; flex-direction: column; gap: 10px;">
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/index.php" style="color: var(--text-secondary); padding: 10px;"><i class="fas fa-home"></i> Dashboard</a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/blogs.php" style="color: var(--primary-color); background: var(--dark-bg); padding: 10px; border-radius: 8px;"><i class="fas fa-blog"></i> Blogs</a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/contacts.php" style="color: var(--text-secondary); padding: 10px;"><i class="fas fa-envelope"></i> Messages</a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/settings.php" style="color: var(--text-secondary); padding: 10px;"><i class="fas fa-cog"></i> Settings</a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/logout.php" style="color: #ff4757; padding: 10px; margin-top: 20px;"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </nav>
        </aside>
        
        <main class="admin-content">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
                <h1>Manage Blogs</h1>
                <a href="edit-blog.php" class="btn btn-primary"><i class="fas fa-plus"></i> New Post</a>
            </div>

            <?php if($message): ?><div style="padding: 15px; background: rgba(46, 213, 115, 0.1); color: #2ed573; border-radius: 8px; margin-bottom: 20px;"><?php echo $message; ?></div><?php endif; ?>
            
            <div style="background: var(--dark-card); border-radius: 12px; overflow: hidden; border: 1px solid var(--border-color);">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Title</th>
                            <th>Category</th>
                            <th>Status</th>
                            <th>Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($blogs as $blog): ?>
                        <tr>
                            <td>#<?php echo $blog['id']; ?></td>
                            <td>
                                <div style="font-weight: 600; color: var(--text-primary);"><?php echo htmlspecialchars($blog['title']); ?></div>
                                <div style="font-size: 12px; color: var(--text-secondary);"><?php echo htmlspecialchars($blog['slug']); ?></div>
                            </td>
                            <td><?php echo htmlspecialchars($blog['category']); ?></td>
                            <td><span class="status-badge status-<?php echo $blog['status']; ?>"><?php echo ucfirst($blog['status']); ?></span></td>
                            <td><?php echo date('M d, Y', strtotime($blog['created_at'])); ?></td>
                            <td>
                                <a href="edit-blog.php?id=<?php echo $blog['id']; ?>" style="color: var(--primary-color); margin-right: 10px;"><i class="fas fa-edit"></i></a>
                                <a href="?delete=<?php echo $blog['id']; ?>" onclick="return confirm('Are you sure?');" style="color: #ff4757;"><i class="fas fa-trash"></i></a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if(empty($blogs)): ?>
                            <tr><td colspan="6" style="text-align: center; padding: 30px; color: var(--text-secondary);">No blog posts found.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
    <script src="../assets/js/main.js"></script>
</body>
</html>
