<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/functions.php';

if (!isLoggedIn()) {
    redirectToLogin();
}

$message = '';
$error = '';

// Handle Delete Action
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    try {
        $stmt = $conn->prepare("DELETE FROM contact_submissions WHERE id = ?");
        $stmt->execute([$id]);
        $message = "Message deleted successfully.";
    } catch(PDOException $e) {
        $error = "Error deleting message.";
    }
}

// Fetch Messages
$submissions = [];
try {
    $stmt = $conn->query("SELECT * FROM contact_submissions ORDER BY created_at DESC");
    $submissions = $stmt->fetchAll();
} catch(PDOException $e) {
    if($conn) {
        $error = "Error fetching interactions.";
    } else {
        $error = "Database not connected.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Messages - Admin</title>
    
    <?php include '../includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo time(); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body, html, a, button, input, textarea { cursor: auto !important; }
        .admin-layout { display: flex; min-height: 100vh; }
        .admin-sidebar { width: 260px; background: var(--dark-card); border-right: 1px solid var(--border-color); padding: var(--spacing-md); }
        .admin-content { flex: 1; padding: var(--spacing-lg); }
        .data-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        .data-table th, .data-table td { padding: 15px; text-align: left; border-bottom: 1px solid var(--border-color); vertical-align: top; }
        .data-table th { background: var(--dark-bg); font-weight: 600; color: var(--primary-color); }
        .message-preview { font-size: 14px; color: var(--text-secondary); margin-top: 5px; display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; }
    </style>
</head>
<body>
    <div class="admin-layout">
        <aside class="admin-sidebar">
            <div class="logo" style="margin-bottom: var(--spacing-lg); font-size: 24px; font-weight: 800; color: var(--primary-color);">LinkBoostify</div>
            <nav style="display: flex; flex-direction: column; gap: 10px;">
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/index.php" style="color: var(--text-secondary); padding: 10px;"><i class="fas fa-home"></i> Dashboard</a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/blogs.php" style="color: var(--text-secondary); padding: 10px;"><i class="fas fa-blog"></i> Blogs</a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/contacts.php" style="color: var(--primary-color); background: var(--dark-bg); padding: 10px; border-radius: 8px;"><i class="fas fa-envelope"></i> Messages</a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/settings.php" style="color: var(--text-secondary); padding: 10px;"><i class="fas fa-cog"></i> Settings</a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/logout.php" style="color: #ff4757; padding: 10px; margin-top: 20px;"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </nav>
        </aside>
        
        <main class="admin-content">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
                <h1>Messages</h1>
            </div>

            <?php if($message): ?><div style="padding: 15px; background: rgba(46, 213, 115, 0.1); color: #2ed573; border-radius: 8px; margin-bottom: 20px;"><?php echo $message; ?></div><?php endif; ?>
            
            <div style="background: var(--dark-card); border-radius: 12px; overflow: hidden; border: 1px solid var(--border-color);">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>From</th>
                            <th>Subject & Message</th>
                            <th>Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($submissions as $msg): ?>
                        <tr>
                            <td style="width: 200px;">
                                <div style="font-weight: 600; color: var(--text-primary);"><?php echo htmlspecialchars($msg['name']); ?></div>
                                <div style="font-size: 12px; color: var(--primary-light);"><?php echo htmlspecialchars($msg['email']); ?></div>
                            </td>
                            <td>
                                <div style="font-weight: 600; color: var(--text-primary);"><?php echo htmlspecialchars($msg['subject']); ?></div>
                                <div class="message-preview"><?php echo htmlspecialchars($msg['message']); ?></div>
                            </td>
                            <td style="width: 150px;"><?php echo date('M d, Y', strtotime($msg['created_at'])); ?></td>
                            <td style="width: 120px;">
                                <button onclick="viewMessage(<?php echo htmlspecialchars(json_encode($msg)); ?>)" style="background: none; border: none; cursor: pointer; color: var(--primary-color); margin-right: 10px;" title="View"><i class="fas fa-eye"></i></button>
                                <a href="mailto:<?php echo htmlspecialchars($msg['email']); ?>" style="color: var(--text-secondary); margin-right: 10px;" title="Reply"><i class="fas fa-reply"></i></a>
                                <a href="?delete=<?php echo $msg['id']; ?>" onclick="return confirm('Are you sure?');" style="color: #ff4757;" title="Delete"><i class="fas fa-trash"></i></a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if(empty($submissions)): ?>
                            <tr><td colspan="4" style="text-align: center; padding: 30px; color: var(--text-secondary);">No messages found.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>

    <!-- View Message Modal -->
    <div id="viewModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); z-index: 1000; align-items: center; justify-content: center;">
        <div style="background: var(--dark-card); width: 100%; max-width: 600px; padding: 30px; border-radius: 12px; border: 1px solid var(--border-color); position: relative;">
            <button onclick="document.getElementById('viewModal').style.display='none'" style="position: absolute; top: 20px; right: 20px; background: none; border: none; color: var(--text-secondary); cursor: pointer; font-size: 20px;"><i class="fas fa-times"></i></button>
            <h2 id="modalSubject" style="margin-bottom: 20px; color: var(--primary-color);"></h2>
            <div style="margin-bottom: 15px; display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                <div>
                    <label style="color: var(--text-secondary); font-size: 12px;">From</label>
                    <div id="modalName" style="font-weight: 600;"></div>
                </div>
                <div>
                    <label style="color: var(--text-secondary); font-size: 12px;">Email</label>
                    <div id="modalEmail" style="font-weight: 600;"></div>
                </div>
            </div>
            <div style="background: rgba(255,255,255,0.05); padding: 20px; border-radius: 8px; max-height: 400px; overflow-y: auto;">
                <label style="color: var(--text-secondary); font-size: 12px; display: block; margin-bottom: 10px;">Message Content</label>
                <div id="modalMessage" style="white-space: pre-line; line-height: 1.6;"></div>
            </div>
        </div>
    </div>

    <script src="../assets/js/main.js"></script>
    <script>
    function viewMessage(msg) {
        document.getElementById('modalSubject').textContent = msg.subject;
        document.getElementById('modalName').textContent = msg.name;
        document.getElementById('modalEmail').textContent = msg.email;
        document.getElementById('modalMessage').textContent = msg.message;
        document.getElementById('viewModal').style.display = 'flex';
    }
    
    // Close modal when clicking outside
    document.getElementById('viewModal').addEventListener('click', function(e) {
        if (e.target === this) {
            this.style.display = 'none';
        }
    });
    </script>
</body>
</html>
