<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/functions.php';

if (!isLoggedIn()) {
    redirectToLogin();
}

// Get statistics
$totalBlogs = 0;
$totalPortfolio = 0;
$totalContacts = 0;

try {
    $stmt = $conn->query("SELECT COUNT(*) as count FROM blogs");
    $totalBlogs = $stmt->fetch()['count'];
    

    
    $stmt = $conn->query("SELECT COUNT(*) as count FROM contact_submissions");
    $totalContacts = $stmt->fetch()['count'];
} catch(PDOException $e) {
    // Handle error
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - LinkBoostify</title>
    
    <?php include '../includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo time(); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body, html, a, button, input, textarea { cursor: auto !important; }
        .admin-layout {
            display: flex;
            min-height: 100vh;
        }
        
        .admin-sidebar {
            width: 260px;
            background: var(--dark-card);
            border-right: 1px solid var(--border-color);
            padding: var(--spacing-md);
        }
        
        .admin-content {
            flex: 1;
            padding: var(--spacing-lg);
        }
        
        .admin-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: var(--spacing-xl);
            padding-bottom: var(--spacing-md);
            border-bottom: 1px solid var(--border-color);
        }
        
        .sidebar-menu {
            margin-top: var(--spacing-lg);
        }
        
        .sidebar-link {
            display: flex;
            align-items: center;
            gap: var(--spacing-sm);
            padding: var(--spacing-sm) var(--spacing-md);
            color: var(--text-secondary);
            border-radius: var(--radius-md);
            margin-bottom: var(--spacing-xs);
            transition: var(--transition-base);
        }
        
        .sidebar-link:hover,
        .sidebar-link.active {
            background: var(--dark-hover);
            color: var(--text-primary);
        }
        
        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: var(--spacing-lg);
            margin-bottom: var(--spacing-xl);
        }
        
        .dashboard-card {
            padding: var(--spacing-lg);
            background: var(--dark-card);
            border: 1px solid var(--border-color);
            border-radius: var(--radius-lg);
        }
        
        .dashboard-card-icon {
            width: 56px;
            height: 56px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: var(--primary-gradient);
            border-radius: var(--radius-md);
            font-size: 24px;
            margin-bottom: var(--spacing-md);
        }
        
        .dashboard-card-value {
            font-size: 36px;
            font-weight: 800;
            background: var(--primary-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body>
    <div class="admin-layout">
        <aside class="admin-sidebar">
            <div class="logo" style="margin-bottom: var(--spacing-lg);">LinkBoostify</div>
            
            <nav class="sidebar-menu">
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/index.php" class="sidebar-link active">
                    <i class="fas fa-home"></i> Dashboard
                </a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/blogs.php" class="sidebar-link">
                    <i class="fas fa-blog"></i> Blogs
                </a>

                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/contacts.php" class="sidebar-link">
                    <i class="fas fa-envelope"></i> Contact Submissions
                </a>
                <a href="settings.php" class="sidebar-link">
                    <i class="fas fa-cog"></i> Settings
                </a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/settings.php" class="sidebar-link">
                    <i class="fas fa-cog"></i> Settings
                </a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/logout.php" class="sidebar-link" style="margin-top: var(--spacing-lg); color: #ff4757;">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </nav>
        </aside>
        
        <main class="admin-content">
            <div class="admin-header">
                <div>
                    <h1>Dashboard</h1>
                    <p style="color: var(--text-secondary); margin-top: 4px;">Welcome back, <?php echo htmlspecialchars($_SESSION['admin_username']); ?>!</p>
                </div>
                <a href="../index.php" class="btn btn-outline" target="_blank">
                    <i class="fas fa-external-link-alt"></i> View Website
                </a>
            </div>
            
            <div class="dashboard-grid">
                <div class="dashboard-card">
                    <div class="dashboard-card-icon">
                        <i class="fas fa-blog"></i>
                    </div>
                    <div class="dashboard-card-value"><?php echo $totalBlogs; ?></div>
                    <div style="color: var(--text-secondary); margin-top: 8px;">Total Blogs</div>
                    <a href="blogs.php" style="color: var(--primary-light); margin-top: 12px; display: inline-block;">
                        Manage Blogs <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
                

                
                <div class="dashboard-card">
                    <div class="dashboard-card-icon">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div class="dashboard-card-value"><?php echo $totalContacts; ?></div>
                    <div style="color: var(--text-secondary); margin-top: 8px;">Contact Submissions</div>
                    <a href="contacts.php" style="color: var(--primary-light); margin-top: 12px; display: inline-block;">
                        View Submissions <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>
            
            <div style="background: var(--dark-card); padding: var(--spacing-lg); border-radius: var(--radius-lg); border: 1px solid var(--border-color);">
                <h2 style="margin-bottom: var(--spacing-md);">Quick Actions</h2>
                <div style="display: flex; gap: var(--spacing-md); flex-wrap: wrap;">
                    <a href="blogs.php?action=new" class="btn btn-primary">
                        <i class="fas fa-plus"></i> New Blog Post
                    </a>

                    <a href="contacts.php" class="btn btn-outline">
                        <i class="fas fa-envelope"></i> View Messages
                    </a>
                </div>
            </div>
        </main>
    </div>
    <script src="../assets/js/main.js"></script>
</body>
</html>
