<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/functions.php';

if (!isLoggedIn()) {
    redirectToLogin();
}

$message = '';
$error = '';
$admin_id = $_SESSION['admin_id'];

// Fetch current user details
try {
    $stmt = $conn->prepare("SELECT * FROM admin_users WHERE id = ?");
    $stmt->execute([$admin_id]);
    $currentUser = $stmt->fetch();
} catch(PDOException $e) {
    $error = "Database error.";
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = sanitizeInput($_POST['username']);
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    if (empty($username)) {
        $error = "Username cannot be empty.";
    } elseif (!empty($new_password) && $new_password !== $confirm_password) {
        $error = "New passwords do not match.";
    } else {
        try {
            // Update Username
            if (!empty($new_password)) {
                // Update Both
                $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                $stmt = $conn->prepare("UPDATE admin_users SET username = ?, password = ? WHERE id = ?");
                $stmt->execute([$username, $hashed_password, $admin_id]);
                $message = "Username and Password updated successfully!";
            } else {
                // Update Username Only
                $stmt = $conn->prepare("UPDATE admin_users SET username = ? WHERE id = ?");
                $stmt->execute([$username, $admin_id]);
                $message = "Username updated successfully!";
            }
            
            // Update Session
            $_SESSION['admin_username'] = $username;
            
            // Refresh User Data
            $currentUser['username'] = $username;
            
        } catch(PDOException $e) {
            $error = "Error updating settings: " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - Admin</title>
    
    <?php include '../includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo time(); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body, html, a, button, input, textarea { cursor: auto !important; }
        .admin-layout { display: flex; min-height: 100vh; }
        .admin-sidebar { width: 260px; background: var(--dark-card); border-right: 1px solid var(--border-color); padding: var(--spacing-md); }
        .admin-content { flex: 1; padding: var(--spacing-lg); }
        .form-group { margin-bottom: 20px; }
        .form-label { display: block; margin-bottom: 8px; color: var(--text-primary); font-weight: 600; }
        .form-control { width: 100%; padding: 12px; background: var(--dark-bg); border: 1px solid var(--border-color); color: white; border-radius: 8px; }
        .form-control:focus { outline: none; border-color: var(--primary-color); }
        .btn-submit { background: var(--primary-gradient); border: none; padding: 12px 30px; color: white; border-radius: 8px; cursor: pointer; font-weight: 600; }
        .settings-card { background: var(--dark-card); padding: 30px; border-radius: 12px; border: 1px solid var(--border-color); max-width: 600px; }
    </style>
</head>
<body>
    <div class="admin-layout">
        <aside class="admin-sidebar">
            <div class="logo" style="margin-bottom: var(--spacing-lg); font-size: 24px; font-weight: 800; color: var(--primary-color);">LinkBoostify</div>
            <nav style="display: flex; flex-direction: column; gap: 10px;">
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/index.php" style="color: var(--text-secondary); padding: 10px;"><i class="fas fa-home"></i> Dashboard</a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/blogs.php" style="color: var(--text-secondary); padding: 10px;"><i class="fas fa-blog"></i> Blogs</a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/contacts.php" style="color: var(--text-secondary); padding: 10px;"><i class="fas fa-envelope"></i> Messages</a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/settings.php" style="color: var(--primary-color); background: var(--dark-bg); padding: 10px; border-radius: 8px;"><i class="fas fa-cog"></i> Settings</a>
                <a href="<?php echo SITE_URL . '/' . ADMIN_PATH; ?>/logout.php" style="color: #ff4757; padding: 10px; margin-top: 20px;"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </nav>
        </aside>
        
        <main class="admin-content">
            <div style="margin-bottom: 30px;">
                <h1>Account Settings</h1>
            </div>

            <?php if($message): ?><div style="padding: 15px; background: rgba(46, 213, 115, 0.1); color: #2ed573; border-radius: 8px; margin-bottom: 20px;"><?php echo $message; ?></div><?php endif; ?>
            <?php if($error): ?><div style="padding: 15px; background: rgba(255, 71, 87, 0.1); color: #ff4757; border-radius: 8px; margin-bottom: 20px;"><?php echo $error; ?></div><?php endif; ?>
            
            <div class="settings-card">
                <form method="POST">
                    <div class="form-group">
                        <label class="form-label">Username</label>
                        <input type="text" name="username" class="form-control" value="<?php echo htmlspecialchars($currentUser['username'] ?? ''); ?>" required>
                    </div>
                    
                    <div style="border-top: 1px solid var(--border-color); margin: 30px 0; padding-top: 20px;">
                        <h3 style="margin-bottom: 20px; color: var(--text-primary);">Change Password</h3>
                        <p style="color: var(--text-secondary); font-size: 14px; margin-bottom: 20px;">Leave blank if you don't want to change the password.</p>
                        
                        <div class="form-group">
                            <label class="form-label">New Password</label>
                            <input type="password" name="new_password" class="form-control" placeholder="Enter new password">
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label">Confirm New Password</label>
                            <input type="password" name="confirm_password" class="form-control" placeholder="Confirm new password">
                        </div>
                    </div>
                    
                    <button type="submit" class="btn-submit">
                        <i class="fas fa-save"></i> Save Changes
                    </button>
                </form>
            </div>
        </main>
    </div>
    <script src="../assets/js/main.js"></script>
</body>
</html>
