<?php
session_start();
require_once 'includes/config.php';
require_once 'includes/functions.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$slug = isset($_GET['slug']) ? $_GET['slug'] : '';

$blog = null;
if ($slug) {
    $blog = getBlogBySlug($slug);
} elseif ($id) {
    $blog = getBlogById($id);
}

if (!$blog) {
    header("HTTP/1.0 404 Not Found");
    echo "<script>alert('Blog post not found!'); window.location.href='blog.php';</script>";
    exit();
}

$page_title = htmlspecialchars($blog['title']) . " - LinkBoostify";

// Resolve Image URL (Absolute if relative)
$imageUrl = $blog['image'];
if ($imageUrl && !preg_match("~^(?:f|ht)tps?://~i", $imageUrl)) {
    $imageUrl = SITE_URL . '/' . $imageUrl;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    
    <?php include 'includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>/assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        .blog-detail-hero {
            padding: 150px 0 80px;
            background: var(--dark-card);
            position: relative;
            overflow: hidden;
        }
        .blog-content-body {
            color: var(--text-primary);
            line-height: 1.8;
            font-size: 18px;
        }
        .blog-content-body img {
            max-width: 100%;
            height: auto;
            border-radius: 8px;
            margin: 20px 0;
            display: block;
        }
        .blog-content-body h2 {
            font-size: 28px;
            color: white;
            margin-top: 40px;
            margin-bottom: 20px;
        }
        .blog-content-body h3 {
            font-size: 24px;
            color: white;
            margin-top: 30px;
            margin-bottom: 15px;
        }
        .blog-content-body p {
            margin-bottom: 20px;
            color: var(--text-secondary);
        }
        .blog-content-body ul, .blog-content-body ol {
            margin-bottom: 20px;
            padding-left: 20px;
            color: var(--text-secondary);
        }
        .blog-content-body li {
            margin-bottom: 10px;
        }
        .blog-content-body blockquote {
            border-left: 4px solid var(--primary-color);
            padding-left: 20px;
            margin: 30px 0;
            font-style: italic;
            color: white;
            background: var(--dark-bg);
            padding: 20px;
            border-radius: 0 8px 8px 0;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <section class="blog-detail-hero">
        <div class="container">
            <div style="max-width: 800px; margin: 0 auto; text-align: center;">
                <span class="section-tag"><?php echo htmlspecialchars($blog['category']); ?></span>
                <h1 style="font-size: clamp(32px, 5vw, 48px); margin: 20px 0; line-height: 1.2;"><?php echo htmlspecialchars($blog['title']); ?></h1>
                <div style="color: var(--text-secondary);">
                    <span><i class="fas fa-calendar"></i> <?php echo date('M d, Y', strtotime($blog['created_at'])); ?></span>
                    <span style="margin-left: 15px;"><i class="fas fa-user"></i> Admin</span>
                </div>
            </div>
        </div>
    </section>

    <section style="padding: 60px 0;">
        <div class="container">
            <div style="max-width: 800px; margin: 0 auto;">
                <?php if($blog['image']): ?>
                    <img src="<?php echo htmlspecialchars($imageUrl); ?>" alt="<?php echo htmlspecialchars($blog['title']); ?>" style="width: 100%; border-radius: 12px; margin-bottom: 40px; box-shadow: var(--shadow-lg); object-fit: cover; max-height: 500px;">
                <?php endif; ?>
                
                <div class="blog-content-body">
                    <?php echo $blog['content']; ?>
                </div>
                
                <div style="margin-top: 60px; padding-top: 40px; border-top: 1px solid var(--border-color); display: flex; justify-content: space-between; align-items: center;">
                    <a href="<?php echo SITE_URL; ?>/blog.php" class="btn btn-outline"><i class="fas fa-arrow-left"></i> Back to Blogs</a>
                    
                    <div style="display: flex; gap: 10px;">
                        <span style="color: var(--text-secondary); margin-right: 10px;">Share:</span>
                        <a href="#" style="color: var(--text-primary);"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" style="color: var(--text-primary);"><i class="fab fa-twitter"></i></a>
                        <a href="#" style="color: var(--text-primary);"><i class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php include 'includes/footer.php'; ?>
    <script src="<?php echo SITE_URL; ?>/assets/js/main.js"></script>
</body>
</html>
