<?php
session_start();
require_once 'includes/config.php';
require_once 'includes/functions.php';

$page_title = "Blog - LinkBoostify";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    
    <?php include 'includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <section class="page-header" style="padding: 120px 0 60px; background: var(--dark-card); margin-top: 70px;">
        <div class="container">
            <div class="section-header">
                <span class="section-tag">Latest Updates</span>
                <h1 class="section-title">Our Blog</h1>
                <p style="color: var(--text-secondary); max-width: 600px; margin: 0 auto;">
                    Insights from our experts on digital marketing, SEO, social media, and more.
                </p>
            </div>
        </div>
    </section>

    <section class="blog-section">
        <div class="container">
            <div class="blog-grid">
                <?php
                $blogs = getAllBlogs();
                if (!empty($blogs)) {
                    foreach ($blogs as $blog) {
                        ?>
                        <div class="blog-card">
                            <div class="blog-image">
                                <img src="<?php echo htmlspecialchars($blog['image']); ?>" alt="<?php echo htmlspecialchars($blog['title']); ?>" loading="lazy" decoding="async">
                                <span class="blog-category"><?php echo htmlspecialchars($blog['category']); ?></span>
                            </div>
                            <div class="blog-content">
                                <div class="blog-meta">
                                    <span><i class="fas fa-calendar"></i> <?php echo date('M d, Y', strtotime($blog['created_at'])); ?></span>
                                    <span><i class="fas fa-user"></i> Admin</span>
                                </div>
                                <h3><?php echo htmlspecialchars($blog['title']); ?></h3>
                                <p><?php 
                                    $excerpt = $blog['excerpt'] ?? '';
                                    if (empty($excerpt)) {
                                        $excerpt = strip_tags($blog['content']);
                                    }
                                    echo htmlspecialchars(substr($excerpt, 0, 150)); 
                                ?>...</p>
                                <a href="blog/<?php echo $blog['slug']; ?>" class="blog-link">
                                    Read More <i class="fas fa-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                        <?php
                    }
                } else {
                    ?>
                    <div class="no-blogs">
                        <i class="fas fa-newspaper"></i>
                        <h3>No Blogs Found</h3>
                        <p>Currently, no blog posts are available. Please check back later.</p>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
    </section>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
</body>
</html>
