<?php
require_once 'includes/config.php';

echo "\n==========================================\n";
echo "   REMOTE DATABASE SETUP (CLI MODE)\n";
echo "==========================================\n";
echo "Host: " . DB_HOST . "\n";
echo "User: " . DB_USER . "\n";
echo "DB:   " . DB_NAME . "\n";
echo "------------------------------------------\n";

try {
    echo "Attempting connection... ";
    $conn = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "✅ CONNECTED!\n\n";

    // Create Admin Users Table
    echo "1. Creating 'admin_users' table... ";
    $conn->exec("CREATE TABLE IF NOT EXISTS `admin_users` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `username` varchar(100) NOT NULL,
        `email` varchar(255) NOT NULL,
        `password` varchar(255) NOT NULL,
        `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        UNIQUE KEY `username` (`username`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
    echo "✅ Done.\n";

    // Create Admin User
    echo "2. Creating Default Admin User... ";
    $pass = password_hash('admin123', PASSWORD_DEFAULT);
    $stmt = $conn->prepare("INSERT IGNORE INTO admin_users (username, email, password) VALUES (?, ?, ?)");
    $stmt->execute(['admin', 'admin@linkboostify.com', $pass]);
    echo "✅ Done (User: admin / Pass: admin123).\n";

    // Create Blogs Table
    echo "3. Creating 'blogs' table... ";
    $conn->exec("CREATE TABLE IF NOT EXISTS `blogs` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `title` varchar(255) NOT NULL,
        `slug` varchar(255) NOT NULL,
        `content` longtext NOT NULL,
        `image` varchar(255) DEFAULT NULL,
        `category` varchar(100) DEFAULT NULL,
        `status` enum('draft','published') DEFAULT 'draft',
        `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
    echo "✅ Done.\n";

    // Create Portfolio Table
    echo "4. Creating 'portfolio' table... ";
    $conn->exec("CREATE TABLE IF NOT EXISTS `portfolio` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `title` varchar(255) NOT NULL,
        `category` varchar(100) DEFAULT NULL,
        `image` varchar(255) DEFAULT NULL,
        `status` enum('active','inactive') DEFAULT 'active',
        `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
    echo "✅ Done.\n";

    // Create Contact Submissions Table
    echo "5. Creating 'contact_submissions' table... ";
    $conn->exec("CREATE TABLE IF NOT EXISTS `contact_submissions` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(255) NOT NULL,
        `email` varchar(255) NOT NULL,
        `message` text NOT NULL,
        `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
    echo "✅ Done.\n";

    echo "\n------------------------------------------\n";
    echo "🎉 SETUP COMPLETE SUCCESSFULLY! 🎉\n";
    echo "==========================================\n";

} catch(PDOException $e) {
    echo "\n❌ ERROR: " . $e->getMessage() . "\n";
    echo "------------------------------------------\n";
    echo "Possible Fixes:\n";
    echo "1. Check if your current IP is allowed in Hostinger 'Remote MySQL'.\n";
    echo "2. Verify the Password is correct.\n"; 
}
?>
