<?php
session_start();
require_once 'includes/config.php';
require_once 'includes/functions.php';

$page_title = "Guest Posting Services - High-Quality Backlinks | LinkBoostify";
$page_description = "Get high-quality guest posts on authoritative websites in your niche. Build powerful backlinks and establish your brand authority with our professional guest posting service.";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <meta name="description" content="<?php echo $page_description; ?>">
    
    <?php include 'includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <!-- Hero Section -->
    <section class="hero-padding" style="background: var(--dark-bg); margin-top: 70px;">
        <div class="container">
            <div class="hero-grid">
                <div>
                    <span style="color: var(--primary-color); font-size: 14px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; display: flex; align-items: center; gap: 8px; margin-bottom: 20px;">
                        <i class="fas fa-circle" style="font-size: 8px;"></i> GUEST POSTING
                    </span>
                    
                    <h1 style="font-size: 56px; font-weight: 800; line-height: 1.1; margin-bottom: 30px; color: var(--text-primary);">
                        Build Authority with <span style="color: var(--primary-color);">Guest Posting</span>
                    </h1>
                    
                    <p style="color: var(--text-secondary); font-size: 18px; line-height: 1.8; margin-bottom: 30px;">
                        Get published on high-authority websites in your niche. Our guest posting service delivers quality backlinks, targeted traffic, and brand recognition through strategic content placement.
                    </p>
                    
                    <div style="display: flex; gap: 15px; margin-bottom: 40px;">
                        <a href="contact-us.php" class="btn btn-primary btn-large">
                            Get Started <i class="fas fa-arrow-right"></i>
                        </a>
                        <a href="#process" class="btn btn-secondary btn-large">
                            See How It Works
                        </a>
                    </div>
                    
                    <!-- Stats -->
                    <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 30px; padding-top: 30px; border-top: 1px solid rgba(255,255,255,0.1);">
                        <div>
                            <h3 style="font-size: 32px; font-weight: 800; color: var(--primary-color); margin-bottom: 5px;">500+</h3>
                            <p style="color: var(--text-secondary); font-size: 14px;">Partner Websites</p>
                        </div>
                        <div>
                            <h3 style="font-size: 32px; font-weight: 800; color: var(--primary-color); margin-bottom: 5px;">DA 50+</h3>
                            <p style="color: var(--text-secondary); font-size: 14px;">Average Authority</p>
                        </div>
                        <div>
                            <h3 style="font-size: 32px; font-weight: 800; color: var(--primary-color); margin-bottom: 5px;">100%</h3>
                            <p style="color: var(--text-secondary); font-size: 14px;">White-Hat</p>
                        </div>
                    </div>
                </div>
                
                <div class="image-anime">
                    <img src="assets/images/guest-posting-hero.png" alt="Guest Posting Service" style="width: 100%; height: auto; border-radius: 12px;" loading="lazy" decoding="async">
                </div>
            </div>
        </div>
    </section>

    <!-- What is Guest Posting -->
    <section style="padding: var(--spacing-xxl) 0; background: var(--dark-card);">
        <div class="container">
            <div style="max-width: 900px; margin: 0 auto; text-align: center;">
                <h2 class="section-title" style="margin-bottom: 30px;">What is <span style="color: var(--primary-color);">Guest Posting?</span></h2>
                <div class="orange-bracket-box">
                    <p style="color: var(--text-secondary); font-size: 18px; line-height: 1.8; margin: 0;">
                        Guest posting is one of the most effective white-hat link building strategies. We publish high-quality, relevant content on authoritative websites in your niche, with natural backlinks pointing to your site. This not only improves your search rankings but also drives targeted traffic and establishes your brand as an industry leader.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Process Section -->
    <section id="process" style="padding: var(--spacing-xxl) 0; background: var(--dark-bg);">
        <div class="container">
            <div class="section-header" style="text-align: center; margin-bottom: 60px;">
                <h2 class="section-title">Our Guest Posting <span style="color: var(--primary-color);">Process</span></h2>
                <p style="color: var(--text-secondary); max-width: 700px; margin: 20px auto 0;">
                    A proven 5-step workflow that delivers results
                </p>
            </div>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: start;">
                <!-- Left Side: Image -->
                <div class="image-anime">
                    <img src="assets/images/guest-posting-process.png" alt="Guest Posting Process" style="width: 100%; height: auto; border-radius: 12px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);" loading="lazy" decoding="async">
                </div>
                
                <!-- Right Side: Process Steps -->
                <div style="display: flex; flex-direction: column; gap: 20px;">
                    <div class="numbered-card">
                        <h3>Niche Research</h3>
                        <span class="card-number">01</span>
                    </div>
                    
                    <div class="numbered-card">
                        <h3>Content Creation</h3>
                        <span class="card-number">02</span>
                    </div>
                    
                    <div class="numbered-card">
                        <h3>Outreach & Placement</h3>
                        <span class="card-number">03</span>
                    </div>
                    
                    <div class="numbered-card">
                        <h3>Publication</h3>
                        <span class="card-number">04</span>
                    </div>
                    
                    <div class="numbered-card">
                        <h3>Reporting</h3>
                        <span class="card-number">05</span>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Benefits Section -->
    <section style="padding: var(--spacing-xxl) 0; background: var(--dark-card);">
        <div class="container">
            <div class="section-header" style="text-align: center; margin-bottom: 60px;">
                <h2 class="section-title">Benefits of <span style="color: var(--primary-color);">Guest Posting</span></h2>
            </div>
            
            <div class="about-grid" style="grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 30px;">
                <div class="modern-benefit-card text-center">
                    <div class="benefit-icon-wrapper mx-auto">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3>Improved Rankings</h3>
                    <p>Quality backlinks from authoritative sites boost your search engine rankings and domain authority.</p>
                </div>
                
                <div class="modern-benefit-card text-center">
                    <div class="benefit-icon-wrapper mx-auto">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3>Targeted Traffic</h3>
                    <p>Reach new audiences and drive qualified visitors who are interested in your niche.</p>
                </div>
                
                <div class="modern-benefit-card text-center">
                    <div class="benefit-icon-wrapper mx-auto">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3>Brand Authority</h3>
                    <p>Establish credibility and position yourself as an industry expert through quality content.</p>
                </div>
                
                <div class="modern-benefit-card text-center">
                    <div class="benefit-icon-wrapper mx-auto">
                        <i class="fas fa-link"></i>
                    </div>
                    <h3>Natural Backlinks</h3>
                    <p>White-hat, editorial links that Google loves and rewards with better rankings.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Choose Us -->
    <section style="padding: var(--spacing-xxl) 0; background: var(--dark-bg);">
        <div class="container">
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 80px; align-items: center;">
                <div>
                    <h2 class="section-title" style="margin-bottom: 30px;">Why Choose <span style="color: var(--primary-color);">LinkBoostify?</span></h2>
                    <p style="color: var(--text-secondary); font-size: 18px; line-height: 1.8; margin-bottom: 30px;">
                        We have established relationships with hundreds of high-quality websites across various niches. Our team ensures every guest post is:
                    </p>
                    
                    <div style="display: flex; flex-direction: column; gap: 15px;">
                        <div style="display: flex; align-items: center; gap: 15px;">
                            <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                            <span style="color: var(--text-primary); font-size: 16px;">Published on sites with real traffic and authority</span>
                        </div>
                        
                        <div style="display: flex; align-items: center; gap: 15px;">
                            <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                            <span style="color: var(--text-primary); font-size: 16px;">Written by professional content creators</span>
                        </div>
                        
                        <div style="display: flex; align-items: center; gap: 15px;">
                            <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                            <span style="color: var(--text-primary); font-size: 16px;">Relevant to your niche and audience</span>
                        </div>
                        
                        <div style="display: flex; align-items: center; gap: 15px;">
                            <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                            <span style="color: var(--text-primary); font-size: 16px;">Compliant with Google's guidelines</span>
                        </div>
                        
                        <div style="display: flex; align-items: center; gap: 15px;">
                            <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                            <span style="color: var(--text-primary); font-size: 16px;">Permanent placements (no temporary links)</span>
                        </div>
                    </div>
                </div>
                
                <div style="background: var(--dark-card); padding: 50px; border-radius: 12px; border: 1px solid rgba(255, 107, 53, 0.1);">
                    <h3 style="font-size: 28px; margin-bottom: 20px; color: var(--text-primary);">Ready to Get Started?</h3>
                    <p style="color: var(--text-secondary); margin-bottom: 30px; line-height: 1.7;">
                        Let's build quality backlinks that drive real results for your business. Get a custom quote today.
                    </p>
                    <a href="contact-us.php" class="btn btn-primary btn-large" style="width: 100%; justify-content: center;">
                        Get a Free Quote <i class="fas fa-arrow-right"></i>
                    </a>
                    
                    <div style="margin-top: 40px; padding-top: 30px; border-top: 1px solid rgba(255,255,255,0.1);">
                        <h4 style="font-size: 16px; margin-bottom: 20px; color: var(--text-primary);">Other Services</h4>
                        <div style="display: flex; flex-direction: column; gap: 10px;">
                            <a href="link-insertion.php" style="color: var(--text-secondary); text-decoration: none; transition: color 0.3s;">
                                <i class="fas fa-arrow-right" style="color: var(--primary-color); margin-right: 10px;"></i> Link Insertion
                            </a>
                            <a href="wikipedia-backlinks.php" style="color: var(--text-secondary); text-decoration: none; transition: color 0.3s;">
                                <i class="fas fa-arrow-right" style="color: var(--primary-color); margin-right: 10px;"></i> Wikipedia Backlinks
                            </a>
                            <a href="pbn-backlinks.php" style="color: var(--text-secondary); text-decoration: none; transition: color 0.3s;">
                                <i class="fas fa-arrow-right" style="color: var(--primary-color); margin-right: 10px;"></i> PBN Backlinks
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php 
    // Set service name for the form
    $form_service_name = 'Guest Posting';
    include 'includes/service-contact-form.php'; 
    ?>

    <?php include 'includes/footer.php'; ?>
    <script src="assets/js/main.js"></script>
</body>
</html>

