<?php
// Helper Functions

function getLatestBlogs($limit = 3) {
    global $conn;
    if (!$conn) return [];
    
    try {
        $stmt = $conn->prepare("SELECT * FROM blogs WHERE status = 'published' ORDER BY created_at DESC LIMIT :limit");
        $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll();
    } catch(PDOException $e) {
        return [];
    }
}

function getAllBlogs() {
    global $conn;
    if (!$conn) return [];
    
    try {
        $stmt = $conn->query("SELECT * FROM blogs WHERE status = 'published' ORDER BY created_at DESC");
        return $stmt->fetchAll();
    } catch(PDOException $e) {
        return [];
    }
}

function getBlogById($id) {
    global $conn;
    if (!$conn) return null;
    
    try {
        $stmt = $conn->prepare("SELECT * FROM blogs WHERE id = :id AND status = 'published'");
        $stmt->execute(['id' => $id]);
        return $stmt->fetch();
    } catch(PDOException $e) {
        return null;
    }
}

function getBlogBySlug($slug) {
    global $conn;
    if (!$conn) return null;
    
    try {
        $stmt = $conn->prepare("SELECT * FROM blogs WHERE slug = :slug AND status = 'published'");
        $stmt->execute(['slug' => $slug]);
        return $stmt->fetch();
    } catch(PDOException $e) {
        return null;
    }
}

function getPortfolioItems($limit = null) {
    global $conn;
    if (!$conn) return [];
    
    try {
        $sql = "SELECT * FROM portfolio WHERE status = 'active' ORDER BY created_at DESC";
        if ($limit) {
            $sql .= " LIMIT " . intval($limit);
        }
        $stmt = $conn->query($sql);
        return $stmt->fetchAll();
    } catch(PDOException $e) {
        return [];
    }
}

function sanitizeInput($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

function sendContactEmail($name, $email, $subject, $message) {
    $to = SITE_EMAIL;
    $headers = "From: " . $email . "\r\n";
    $headers .= "Reply-To: " . $email . "\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
    
    $email_subject = "Contact Form: " . $subject;
    $email_body = "
    <html>
    <body>
        <h2>New Contact Form Submission</h2>
        <p><strong>Name:</strong> {$name}</p>
        <p><strong>Email:</strong> {$email}</p>
        <p><strong>Subject:</strong> {$subject}</p>
        <p><strong>Message:</strong></p>
        <p>{$message}</p>
    </body>
    </html>
    ";
    
    return mail($to, $email_subject, $email_body, $headers);
}

function isLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

function redirectToLogin() {
    header('Location: ' . SITE_URL . '/' . ADMIN_PATH . '/login.php');
    exit();
}
?>
