<?php
/**
 * Service Contact Form Component
 * Reusable contact form for all service pages
 * 
 * Usage: include 'includes/service-contact-form.php';
 * 
 * Variables (optional):
 * $form_service_name - Pre-selected service name (default: current page service)
 * $form_heading - Custom heading (default: "Feel Free To Ask us Anything!")
 * $form_subheading - Custom subheading (default: service-specific)
 */

// Default values
$form_service_name = $form_service_name ?? 'Guest Posting';
$form_heading = $form_heading ?? 'Feel Free To <span style="color: var(--primary-color);">Ask us Anything!</span>';
$form_subheading = $form_subheading ?? 'Get a custom quote for your ' . $form_service_name . ' needs';
?>

<!-- Service Contact Form Section -->
<section style="padding: var(--spacing-xxl) 0; background: var(--dark-bg);">
    <div class="container">
        <div style="max-width: 900px; margin: 0 auto;">
            <div style="text-align: center; margin-bottom: 50px;">
                <h2 class="section-title"><?php echo $form_heading; ?></h2>
                <p style="color: var(--text-secondary); margin-top: 15px;"><?php echo $form_subheading; ?></p>
            </div>

            <form id="serviceContactForm" method="POST" action="process-service-form.php" style="background: var(--dark-card); padding: 50px; border-radius: 16px; border: 1px solid rgba(255, 107, 53, 0.1);">
                <!-- Project Type Selection -->
                <div style="margin-bottom: 30px;">
                    <label style="display: block; color: var(--text-primary); font-weight: 600; margin-bottom: 15px; font-size: 16px;">What type of project?</label>
                    <div style="display: flex; flex-wrap: wrap; gap: 12px;">
                        <label class="service-option-btn <?php echo ($form_service_name == 'Guest Posting') ? 'active' : ''; ?>">
                            <input type="radio" name="project_type" value="Guest Posting" <?php echo ($form_service_name == 'Guest Posting') ? 'checked' : ''; ?> style="display: none;">
                            <span>Guest Posting</span>
                        </label>
                        <label class="service-option-btn <?php echo ($form_service_name == 'Link Insertion') ? 'active' : ''; ?>">
                            <input type="radio" name="project_type" value="Link Insertion" <?php echo ($form_service_name == 'Link Insertion') ? 'checked' : ''; ?> style="display: none;">
                            <span>Link Insertion</span>
                        </label>
                        <label class="service-option-btn <?php echo ($form_service_name == 'Wikipedia Backlinks') ? 'active' : ''; ?>">
                            <input type="radio" name="project_type" value="Wikipedia Backlinks" <?php echo ($form_service_name == 'Wikipedia Backlinks') ? 'checked' : ''; ?> style="display: none;">
                            <span>Wikipedia Backlinks</span>
                        </label>
                        <label class="service-option-btn <?php echo ($form_service_name == 'PBN Backlinks') ? 'active' : ''; ?>">
                            <input type="radio" name="project_type" value="PBN Backlinks" <?php echo ($form_service_name == 'PBN Backlinks') ? 'checked' : ''; ?> style="display: none;">
                            <span>PBN Backlinks</span>
                        </label>
                        <label class="service-option-btn">
                            <input type="radio" name="project_type" value="Other" style="display: none;">
                            <span>Other</span>
                        </label>
                    </div>
                </div>

                <!-- Budget Range -->
                <div style="margin-bottom: 30px;">
                    <label style="display: block; color: var(--text-primary); font-weight: 600; margin-bottom: 15px; font-size: 16px;">Budget Range?</label>
                    <div style="display: flex; flex-wrap: wrap; gap: 12px;">
                        <label class="service-option-btn">
                            <input type="radio" name="budget" value="500 - 1k" style="display: none;">
                            <span>500 - 1k</span>
                        </label>
                        <label class="service-option-btn">
                            <input type="radio" name="budget" value="1k - 3k" style="display: none;">
                            <span>1k - 3k</span>
                        </label>
                        <label class="service-option-btn">
                            <input type="radio" name="budget" value="3k - 5k" style="display: none;">
                            <span>3k - 5k</span>
                        </label>
                        <label class="service-option-btn">
                            <input type="radio" name="budget" value="5k - 10k" style="display: none;">
                            <span>5k - 10k</span>
                        </label>
                        <label class="service-option-btn">
                            <input type="radio" name="budget" value="10k+" style="display: none;">
                            <span>10k+</span>
                        </label>
                    </div>
                </div>

                <!-- How did you hear about us -->
                <div style="margin-bottom: 30px;">
                    <label style="display: block; color: var(--text-primary); font-weight: 600; margin-bottom: 15px; font-size: 16px;">How did you hear about us?</label>
                    <div style="display: flex; flex-wrap: wrap; gap: 12px;">
                        <label class="service-option-btn">
                            <input type="radio" name="referral" value="Google" style="display: none;">
                            <span>Google</span>
                        </label>
                        <label class="service-option-btn">
                            <input type="radio" name="referral" value="Social Media" style="display: none;">
                            <span>Social Media</span>
                        </label>
                        <label class="service-option-btn">
                            <input type="radio" name="referral" value="Friend Referral" style="display: none;">
                            <span>Friend Referral</span>
                        </label>
                        <label class="service-option-btn">
                            <input type="radio" name="referral" value="Blog/Article" style="display: none;">
                            <span>Blog/Article</span>
                        </label>
                        <label class="service-option-btn">
                            <input type="radio" name="referral" value="Other" style="display: none;">
                            <span>Other</span>
                        </label>
                    </div>
                </div>

                <!-- Name Fields -->
                <div class="form-grid-2">
                    <div>
                        <input type="text" name="first_name" placeholder="First name" required style="width: 100%; padding: 16px 20px; background: rgba(255, 255, 255, 0.05); border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 8px; color: var(--text-primary); font-size: 15px; transition: all 0.3s;">
                    </div>
                    <div>
                        <input type="text" name="last_name" placeholder="Last name" required style="width: 100%; padding: 16px 20px; background: rgba(255, 255, 255, 0.05); border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 8px; color: var(--text-primary); font-size: 15px; transition: all 0.3s;">
                    </div>
                </div>

                <!-- Contact Fields -->
                <div class="form-grid-2">
                    <div>
                        <input type="tel" name="mobile" placeholder="Enter your mobile no." required style="width: 100%; padding: 16px 20px; background: rgba(255, 255, 255, 0.05); border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 8px; color: var(--text-primary); font-size: 15px; transition: all 0.3s;">
                    </div>
                    <div>
                        <input type="email" name="email" placeholder="Enter your e-mail" required style="width: 100%; padding: 16px 20px; background: rgba(255, 255, 255, 0.05); border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 8px; color: var(--text-primary); font-size: 15px; transition: all 0.3s;">
                    </div>
                </div>

                <!-- Message Field -->
                <div style="margin-bottom: 30px;">
                    <textarea name="message" placeholder="Write message..." rows="5" style="width: 100%; padding: 16px 20px; background: rgba(255, 255, 255, 0.05); border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 8px; color: var(--text-primary); font-size: 15px; resize: vertical; transition: all 0.3s;"></textarea>
                </div>

                <!-- Submit Button -->
                <button type="submit" style="display: inline-flex; align-items: center; gap: 12px; padding: 16px 40px; background: var(--primary-gradient); color: white; border: none; border-radius: 50px; font-weight: 700; font-size: 16px; cursor: pointer; transition: all 0.3s; box-shadow: 0 8px 20px rgba(255, 107, 53, 0.3);">
                    Submit Message
                    <span style="width: 32px; height: 32px; background: white; color: var(--primary-color); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-arrow-right"></i>
                    </span>
                </button>

                <div id="formMessage" style="margin-top: 20px; padding: 15px; border-radius: 8px; display: none;"></div>
            </form>
        </div>
    </div>
</section>

<script>
// Service Contact Form Handler
document.getElementById('serviceContactForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const messageDiv = document.getElementById('formMessage');
    
    // Show loading
    messageDiv.style.display = 'block';
    messageDiv.style.background = 'rgba(255, 107, 53, 0.1)';
    messageDiv.style.color = 'var(--primary-color)';
    messageDiv.style.border = '1px solid var(--primary-color)';
    messageDiv.textContent = 'Sending your message...';
    
    // AJAX submission
    fetch('process-service-form.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            messageDiv.style.background = 'rgba(67, 233, 123, 0.1)';
            messageDiv.style.color = '#43e97b';
            messageDiv.style.border = '1px solid #43e97b';
            messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message;
            this.reset();
            
            // Reset radio button styles
            document.querySelectorAll('.service-option-btn').forEach(btn => {
                btn.classList.remove('active');
            });
            // Re-activate default option
            document.querySelector('.service-option-btn.active').classList.add('active');
        } else {
            messageDiv.style.background = 'rgba(245, 87, 108, 0.1)';
            messageDiv.style.color = '#f5576c';
            messageDiv.style.border = '1px solid #f5576c';
            messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
        }
    })
    .catch(error => {
        messageDiv.style.background = 'rgba(245, 87, 108, 0.1)';
        messageDiv.style.color = '#f5576c';
        messageDiv.style.border = '1px solid #f5576c';
        messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Something went wrong. Please try again.';
    });
});

// Radio button styling
document.querySelectorAll('.service-option-btn input').forEach(input => {
    input.addEventListener('change', function() {
        // Remove active class from all buttons in this group
        this.closest('div').querySelectorAll('.service-option-btn').forEach(btn => {
            btn.classList.remove('active');
        });
        // Add active class to selected button
        this.closest('.service-option-btn').classList.add('active');
    });
});

// Input focus effects
document.querySelectorAll('#serviceContactForm input, #serviceContactForm textarea').forEach(input => {
    input.addEventListener('focus', function() {
        this.style.borderColor = 'var(--primary-color)';
        this.style.background = 'rgba(255, 107, 53, 0.05)';
    });
    input.addEventListener('blur', function() {
        this.style.borderColor = 'rgba(255, 255, 255, 0.1)';
        this.style.background = 'rgba(255, 255, 255, 0.05)';
    });
});
</script>
