<?php
session_start();
require_once 'includes/config.php';
require_once 'includes/functions.php';

$page_title = "LinkBoostify - High-Quality Backlinks & Link Building Services";
$page_description = "LinkBoostify specializes in building powerful backlinks that boost search rankings, drive organic traffic, and establish your website's authority. Guest posting, link insertion, Wikipedia & PBN backlinks.";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <meta name="description" content="<?php echo $page_description; ?>">
    
    <?php include 'includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="hero-grid">
                <div class="hero-content">
                    <h1 class="hero-title" style="display: flex; flex-direction: column; align-items: flex-start; gap: 5px;">
                        <div class="typewriter" style="animation: typing 1s steps(40, end) forwards, blink-caret .75s step-end infinite, transparent-border 0s step-end 1s forwards;">Boost Your</div>
                        <div class="typewriter" style="animation: typing 1s steps(40, end) forwards, blink-caret .75s step-end infinite, transparent-border 0s step-end 2s forwards; animation-delay: 1s;">Rankings with</div>
                        <div class="typewriter" style="animation: typing 1.5s steps(40, end) forwards, blink-caret .75s step-end infinite, transparent-border 0s step-end 3.5s forwards; animation-delay: 2s;">
                            <span class="text-orange">High-Quality Backlinks</span>
                        </div>
                    </h1>
                    <p class="hero-subtitle animate-fade-in-delay">
                        LinkBoostify specializes in building powerful backlinks that drive organic traffic, improve search rankings, and establish your website's authority in your niche.
                    </p>
                    <a href="contact-us.php" class="btn-zyniq animate-fade-in-delay-2">
                        <span class="btn-text">Get Started</span>
                        <span class="btn-icon-circle"><i class="fas fa-arrow-right"></i></span>
                    </a>
                </div>
                <div class="hero-image reveal reveal-delay-2">
                    <img src="assets/images/hero-character.png" alt="Digital Marketing Professional" class="hero-character" loading="eager">
                    <div class="hero-badge">
                        <i class="fas fa-users"></i>
                        <div>
                            <strong>2500+</strong>
                            <span>Satisfied Client</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- About Us Section -->
    <section class="about-intro-section">
        <div class="container">
            <div class="about-intro-grid">
                <div class="about-intro-image reveal-wipe">
                    <img src="assets/images/about-team.png" alt="Our Team" class="team-image" loading="lazy" decoding="async">
                </div>
                <div class="about-intro-content reveal reveal-delay-2">
                    <span class="section-tag">ABOUT US</span>
                    <!-- Added type-reveal -->
                    <h2 class="about-intro-title type-reveal">
                        Your Trusted <span class="text-orange">Link Building Partner</span>
                    </h2>
                    <div class="about-intro-text">
                        <p>At LinkBoostify, we specialize in building high-quality backlinks that boost your website's authority and search engine rankings. From guest posting and link insertion to Wikipedia backlinks and PBN services, we deliver white-hat link building strategies that drive real, measurable results for your business.</p>
                    </div>
                    <a href="about-us.php" class="btn-glow-pill">
                        More About <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="stats-section">
        <div class="container">
            <div class="stats-grid">
                <div class="stat-card reveal-scale reveal-delay-1">
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3 class="stat-number" data-count="2500">0</h3>
                    <p class="stat-label">Happy Clients</p>
                </div>
                <!-- ... other stat cards ... -->
                <div class="stat-card reveal-scale reveal-delay-2">
                    <div class="stat-icon">
                        <i class="fas fa-project-diagram"></i>
                    </div>
                    <h3 class="stat-number" data-count="3200">0</h3>
                    <p class="stat-label">Projects Completed</p>
                </div>
                 <div class="stat-card reveal-scale reveal-delay-3">
                    <div class="stat-icon">
                        <i class="fas fa-award"></i>
                    </div>
                    <h3 class="stat-number" data-count="150">0</h3>
                    <p class="stat-label">Awards Won</p>
                </div>
                 <div class="stat-card reveal-scale reveal-delay-1">
                    <div class="stat-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h3 class="stat-number" data-count="8">0</h3>
                    <p class="stat-label">Years Experience</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section class="services-section">
        <div class="container">
            <div class="section-header-left reveal">
                <span class="section-tag-orange"><i class="fas fa-bolt"></i> OUR SERVICES</span>
                <!-- Added type-reveal -->
                <h2 class="section-title type-reveal">What We Do Best</h2>
                <div class="header-actions">
                    <a href="services.php" class="btn btn-dark-pill">See All Services <i class="fas fa-arrow-right"></i></a>
                </div>
            </div>
            
            <div class="services-wrapper">
                <!-- Left Column Images -->
                <div class="services-images reveal-left">
                    <div class="service-img-card top-img">
                        <img src="assets/images/service-1.png" alt="Social Media Strategy" loading="lazy" decoding="async">
                    </div>
                    <div class="service-img-card bottom-img">
                        <img src="assets/images/service-2.png" alt="Digital Engagement" loading="lazy" decoding="async">
                    </div>
                </div>

                <!-- Right Column Service Cards -->
                <div class="services-cards-grid">
                    <!-- Guest Posting Service (Delay 1) -->
                    <div class="service-process-card reveal-right reveal-delay-1">
                        <div class="service-icon-box">
                            <i class="fas fa-newspaper"></i>
                        </div>
                        <h3>Guest Posting</h3>
                        <p>Get your content published on high-authority websites in your niche. Our guest posting service builds quality backlinks while establishing your brand as an industry authority.</p>
                        <a href="guest-posting.php" class="read-more-link">Read More <i class="fas fa-arrow-right"></i></a>
                    </div>

                    <!-- Link Insertion Service (Delay 2) -->
                    <div class="service-process-card reveal-right reveal-delay-2">
                        <div class="service-icon-box">
                            <i class="fas fa-link"></i>
                        </div>
                        <h3>Link Insertion</h3>
                        <p>Strategic placement of your links in existing high-ranking content. We secure contextual backlinks that pass maximum authority and drive targeted traffic to your site.</p>
                        <a href="link-insertion.php" class="read-more-link">Read More <i class="fas fa-arrow-right"></i></a>
                    </div>

                    <!-- Wikipedia Backlinks (Delay 3) -->
                    <div class="service-process-card reveal-right reveal-delay-3">
                        <div class="service-icon-box">
                            <i class="fab fa-wikipedia-w"></i>
                        </div>
                        <h3>Wikipedia Backlinks</h3>
                        <p>Secure valuable backlinks from Wikipedia, one of the most trusted sources online. Boost your credibility and domain authority with expert Wikipedia link building.</p>
                        <a href="wikipedia-backlinks.php" class="read-more-link">Read More <i class="fas fa-arrow-right"></i></a>
                    </div>

                    <!-- PBN Backlinks (Delay 4) -->
                    <div class="service-process-card reveal-right reveal-delay-4">
                        <div class="service-icon-box">
                            <i class="fas fa-network-wired"></i>
                        </div>
                        <h3>PBN Backlinks</h3>
                        <p>Leverage our premium Private Blog Network for powerful, high-authority backlinks. Safe, effective, and designed to boost your rankings quickly and sustainably.</p>
                        <a href="pbn-backlinks.php" class="read-more-link">Read More <i class="fas fa-arrow-right"></i></a>
                    </div>

                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container">
            <div class="cta-content">
                <!-- Added type-reveal -->
                <h2 class="type-reveal">Ready to Grow Your Business?</h2>
                <p>Let's achieve social media excellence together</p>
                <a href="contact-us.php" class="btn btn-white btn-large">
                    Contact Us Today <i class="fas fa-arrow-right"></i>
                </a>
            </div>
        </div>
    </section>

    <!-- Feature Circle Section -->
    <section class="feature-circle-section">
        <div class="container">
            <!-- Added Section Header -->
            <div class="section-header text-center reveal" style="margin-bottom: 60px;">
                <span class="section-tag-orange">WHY CHOOSE US</span>
                <h2 class="section-title type-reveal">Why We Are Different</h2>
            </div>

            <div class="feature-circle-wrapper">
                <!-- Left Features -->
                <div class="feature-column left reveal reveal-delay-1">
                    <div class="feature-block">
                        <div class="feature-title">
                            <i class="fas fa-check-circle text-orange"></i>
                            <h3>Quality Over Quantity</h3>
                        </div>
                        <p>We focus on high-authority, relevant backlinks that truly impact your rankings, not just numbers.</p>
                    </div>
                    
                    <div class="feature-block">
                        <div class="feature-title">
                            <i class="fas fa-check-circle text-orange"></i>
                            <h3>White-Hat Only</h3>
                        </div>
                        <p>100% safe, Google-compliant link building techniques. No spam, no penalties, just sustainable growth.</p>
                    </div>
                </div>

                <!-- Center Circle Image -->
                <div class="feature-center-visual reveal-wipe">
                    <div class="pulse-circle-1"></div>
                    <div class="pulse-circle-2"></div>
                    <div class="center-image-container">
                        <img src="assets/images/feature-circle.png" alt="Digital Expert" class="feature-main-img" loading="lazy" decoding="async">
                    </div>
                    
                    <!-- Orbit Ring Container -->
                    <div class="orbit-ring">
                        <div class="orbit-icon icon-1"><i class="fas fa-link"></i></div>
                        <div class="orbit-icon icon-2"><i class="fas fa-chart-line"></i></div>
                        <div class="orbit-icon icon-3"><i class="fab fa-wikipedia-w"></i></div>
                        <div class="orbit-icon icon-4"><i class="fas fa-newspaper"></i></div>
                        <div class="orbit-icon icon-5"><i class="fas fa-network-wired"></i></div>
                        <div class="orbit-icon icon-6"><i class="fas fa-search"></i></div>
                    </div>
                </div>

                <!-- Right Features -->
                <div class="feature-column right reveal reveal-delay-1">
                    <div class="feature-block">
                        <div class="feature-title">
                            <i class="fas fa-check-circle text-orange"></i>
                            <h3>Detailed Reporting</h3>
                        </div>
                        <p>Complete transparency with detailed reports showing every backlink, metrics, and progress tracking.</p>
                    </div>

                    <div class="feature-block">
                        <div class="feature-title">
                            <i class="fas fa-check-circle text-orange"></i>
                            <h3>Proven Results</h3>
                        </div>
                        <p>Track record of boosting rankings and organic traffic for businesses across competitive niches.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Blog Section -->
    <section class="blog-section">
        <div class="container">
            <div class="section-header reveal">
                <span class="section-tag">Latest Updates</span>
                <!-- Added type-reveal -->
                <h2 class="section-title type-reveal">Insights from our experts</h2>
            </div>
            <div class="blog-grid">
                <?php
                $blogs = getLatestBlogs(3);
                if (!empty($blogs)) {
                    foreach ($blogs as $blog) {
                        ?>
                        <div class="blog-card reveal-wipe">
                            <div class="blog-image">
                                <img src="<?php echo htmlspecialchars($blog['image']); ?>" alt="<?php echo htmlspecialchars($blog['title']); ?>" loading="lazy" decoding="async">
                                <span class="blog-category"><?php echo htmlspecialchars($blog['category']); ?></span>
                            </div>
                            <div class="blog-content">
                                <div class="blog-meta">
                                    <span><i class="fas fa-calendar"></i> <?php echo date('M d, Y', strtotime($blog['created_at'])); ?></span>
                                    <span><i class="fas fa-user"></i> Admin</span>
                                </div>
                                <h3><?php echo htmlspecialchars($blog['title']); ?></h3>
                                <p><?php echo htmlspecialchars(substr($blog['excerpt'], 0, 120)); ?>...</p>
                                <a href="blog/<?php echo $blog['slug']; ?>" class="blog-link">
                                    Read More <i class="fas fa-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                        <?php
                    }
                } else {
                    ?>
                    <div class="reveal">
                        <div class="no-blogs">
                            <i class="fas fa-newspaper"></i>
                            <h3>No Blogs Found</h3>
                            <p>Currently, no blog posts are available. Please check back later.</p>
                        </div>
                    </div>
                    <?php
                }
                ?>
            </div>
            <div class="text-center reveal" style="margin-top: 40px;">
                <a href="blog.php" class="btn btn-outline">
                    View All Blogs <i class="fas fa-arrow-right"></i>
                </a>
            </div>
        </div>
    </section>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
</body>
</html>
