<?php
session_start();
require_once 'includes/config.php';
require_once 'includes/functions.php';

$page_title = "PBN Backlinks - High Authority Premium Network | LinkBoostify";
$page_description = "Dominate search rankings with our private, high-authority blog network. Safe, footprint-free PBN backlinks that deliver rapid SEO results.";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <meta name="description" content="<?php echo $page_description; ?>">
    
    <?php include 'includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <!-- Hero Section -->
    <section class="hero-padding" style="background: var(--dark-bg); margin-top: 70px;">
        <div class="container">
            <div class="hero-grid">
                <div>
                    <span style="color: var(--primary-color); font-size: 14px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; display: flex; align-items: center; gap: 8px; margin-bottom: 20px;">
                        <i class="fas fa-circle" style="font-size: 8px;"></i> PREMIUM NETWORK
                    </span>
                    
                    <h1 style="font-size: 56px; font-weight: 800; line-height: 1.1; margin-bottom: 30px; color: var(--text-primary);">
                        Unleash Power with <span style="color: var(--primary-color);">PBN Backlinks</span>
                    </h1>
                    
                    <p style="color: var(--text-secondary); font-size: 18px; line-height: 1.8; margin-bottom: 30px;">
                        The fastest way to boost your rankings. Our private network of aged, high-authority domains delivers massive link juice without the footprints.
                    </p>
                    
                    <div style="display: flex; gap: 15px; margin-bottom: 40px;">
                        <a href="contact-us.php" class="btn btn-primary btn-large">
                            Boost Rankings <i class="fas fa-rocket"></i>
                        </a>
                        <a href="#network" class="btn btn-secondary btn-large">
                            See Metrics
                        </a>
                    </div>
                    
                    <!-- Stats -->
                    <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 30px; padding-top: 30px; border-top: 1px solid rgba(255,255,255,0.1);">
                        <div>
                            <h3 style="font-size: 32px; font-weight: 800; color: var(--primary-color); margin-bottom: 5px;">500+</h3>
                            <p style="color: var(--text-secondary); font-size: 14px;">Private Domains</p>
                        </div>
                        <div>
                            <h3 style="font-size: 32px; font-weight: 800; color: var(--primary-color); margin-bottom: 5px;">DA 40+</h3>
                            <p style="color: var(--text-secondary); font-size: 14px;">Average Metrics</p>
                        </div>
                        <div>
                            <h3 style="font-size: 32px; font-weight: 800; color: var(--primary-color); margin-bottom: 5px;">0%</h3>
                            <p style="color: var(--text-secondary); font-size: 14px;">Footprints</p>
                        </div>
                    </div>
                </div>
                
                <div class="image-anime">
                    <img src="assets/images/pbn-hero.png" alt="PBN Backlinks" style="width: 100%; height: auto; border-radius: 12px; box-shadow: 0 0 40px rgba(255, 107, 53, 0.1);" loading="lazy" decoding="async">
                </div>
            </div>
        </div>
    </section>

    <!-- What is PBN -->
    <section style="padding: var(--spacing-xxl) 0; background: var(--dark-card);">
        <div class="container">
            <div style="max-width: 900px; margin: 0 auto; text-align: center;">
                <h2 class="section-title" style="margin-bottom: 30px;">Power of <span style="color: var(--primary-color);">Private Networks</span></h2>
                <div class="orange-bracket-box">
                    <p style="color: var(--text-secondary); font-size: 18px; line-height: 1.8; margin: 0;">
                        A Private Blog Network (PBN) is a collection of high-authority websites used to build backlinks to your money site. When managed correctly with zero footprints, PBN links are one of the most powerful tools to dominate competitive niches where standard outreach isn't enough.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Network Features -->
    <section id="network" style="padding: var(--spacing-xxl) 0; background: var(--dark-bg);">
        <div class="container">
            <div class="section-header" style="text-align: center; margin-bottom: 60px;">
                <h2 class="section-title">Our Network <span style="color: var(--primary-color);">Features</span></h2>
                <p style="color: var(--text-secondary); max-width: 700px; margin: 20px auto 0;">
                    Built for safety, stealth, and SEO power
                </p>
            </div>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: start;">
                
                <!-- Left Side: Process Steps -->
                <div style="display: flex; flex-direction: column; gap: 20px;">
                    <div class="numbered-card">
                        <h3>Clean Aged Domains</h3>
                        <span class="card-number">01</span>
                    </div>
                    
                    <div class="numbered-card">
                        <h3>Unique Class C IPs</h3>
                        <span class="card-number">02</span>
                    </div>
                    
                    <div class="numbered-card">
                        <h3>Different Hosting Providers</h3>
                        <span class="card-number">03</span>
                    </div>
                    
                    <div class="numbered-card">
                        <h3>Handwritten Content</h3>
                        <span class="card-number">04</span>
                    </div>
                    
                    <div class="numbered-card">
                        <h3>No Interlinking</h3>
                        <span class="card-number">05</span>
                    </div>
                </div>

                 <!-- Right Side: Image -->
                <div class="image-anime">
                    <img src="assets/images/pbn-process.png" alt="PBN Structure" style="width: 100%; height: auto; border-radius: 12px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);" loading="lazy" decoding="async">
                </div>
            </div>
        </div>
    </section>

    <!-- Benefits Section -->
    <section style="padding: var(--spacing-xxl) 0; background: var(--dark-card);">
        <div class="container">
            <div class="section-header" style="text-align: center; margin-bottom: 60px;">
                <h2 class="section-title">Why Use <span style="color: var(--primary-color);">PBN Links?</span></h2>
            </div>
            
            <div class="about-grid" style="grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 30px;">
                <div class="modern-benefit-card text-center">
                    <div class="benefit-icon-wrapper mx-auto">
                        <i class="fas fa-rocket"></i>
                    </div>
                    <h3>Rapid Ranking</h3>
                    <p>PBNs pass massive authority instantly, often moving the needle in weeks rather than months.</p>
                </div>
                
                <div class="modern-benefit-card text-center">
                    <div class="benefit-icon-wrapper mx-auto">
                        <i class="fas fa-sliders-h"></i>
                    </div>
                    <h3>Total Control</h3>
                    <p>You control the anchor text, the content context, and the link placement for perfect optimization.</p>
                </div>
                
                <div class="modern-benefit-card text-center">
                    <div class="benefit-icon-wrapper mx-auto">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3>Footprint Free</h3>
                    <p>Our network is built with paranoia-level safety. No shared footprints or patterns for Google to detect.</p>
                </div>
                
                <div class="modern-benefit-card text-center">
                    <div class="benefit-icon-wrapper mx-auto">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3>Niche Relevance</h3>
                    <p>We place your links on domains that are thematically relevant to your industry for maximum impact.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Process & Safety -->
    <section style="padding: var(--spacing-xxl) 0; background: var(--dark-bg);">
        <div class="container">
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 80px; align-items: start;">
                <div>
                    <h2 class="section-title" style="margin-bottom: 30px;">Our Safety <span style="color: var(--primary-color);">Guarantee</span></h2>
                    <p style="color: var(--text-secondary); font-size: 18px; line-height: 1.8; margin-bottom: 30px;">
                        Safety is our #1 priority. We treat your site like our own. Our network is maintained with strict protocols:
                    </p>
                    
                    <div style="display: flex; flex-direction: column; gap: 15px;">
                        <div style="display: flex; align-items: center; gap: 15px;">
                            <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                            <span style="color: var(--text-primary); font-size: 16px;">Different Registrars & WHOIS Privacy</span>
                        </div>
                        
                        <div style="display: flex; align-items: center; gap: 15px;">
                            <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                            <span style="color: var(--text-primary); font-size: 16px;">Unique Themes & Plugins per site</span>
                        </div>
                        
                        <div style="display: flex; align-items: center; gap: 15px;">
                            <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                            <span style="color: var(--text-primary); font-size: 16px;">Natural outbound link profiles</span>
                        </div>
                        
                        <div style="display: flex; align-items: center; gap: 15px;">
                            <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                            <span style="color: var(--text-primary); font-size: 16px;">Blocked bots (Ahrefs, Majestic, Moz)</span>
                        </div>
                    </div>
                </div>
                
                <div style="background: var(--dark-card); padding: 50px; border-radius: 12px; border: 1px solid rgba(255, 107, 53, 0.1);">
                    <h3 style="font-size: 28px; margin-bottom: 20px; color: var(--text-primary);">Dominate Your Niche</h3>
                    <p style="color: var(--text-secondary); margin-bottom: 30px; line-height: 1.7;">
                        Ready to leave your competitors behind? Get the unfair advantage with our premium PBN links.
                    </p>
                    <a href="contact-us.php" class="btn btn-primary btn-large" style="width: 100%; justify-content: center;">
                        Order PBN Links <i class="fas fa-arrow-right"></i>
                    </a>
                    
                    <div style="margin-top: 40px; padding-top: 30px; border-top: 1px solid rgba(255,255,255,0.1);">
                        <h4 style="font-size: 16px; margin-bottom: 20px; color: var(--text-primary);">Recommended For:</h4>
                        <div style="display: flex; flex-wrap: wrap; gap: 10px;">
                           <span style="background: rgba(255,255,255,0.05); padding: 5px 15px; border-radius: 20px; font-size: 14px; color: var(--text-secondary);">High Competition</span>
                           <span style="background: rgba(255,255,255,0.05); padding: 5px 15px; border-radius: 20px; font-size: 14px; color: var(--text-secondary);">Affiliate Rankings</span>
                           <span style="background: rgba(255,255,255,0.05); padding: 5px 15px; border-radius: 20px; font-size: 14px; color: var(--text-secondary);">Local Maps</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php 
    $form_service_name = 'PBN Backlinks';
    include 'includes/service-contact-form.php'; 
    ?>

    <?php include 'includes/footer.php'; ?>
    <script src="assets/js/main.js"></script>
</body>
</html>

