<?php
$page_title = "Privacy Policy - LinkBoostify";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    
    <?php include 'includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        .legal-content {
            max-width: 900px;
            margin: 0 auto;
            padding: var(--spacing-xxl) var(--spacing-md);
        }
        
        .legal-content h2 {
            font-size: 28px;
            margin-top: var(--spacing-xl);
            margin-bottom: var(--spacing-md);
            color: var(--text-primary);
        }
        
        .legal-content h3 {
            font-size: 22px;
            margin-top: var(--spacing-lg);
            margin-bottom: var(--spacing-sm);
            color: var(--primary-color);
        }
        
        .legal-content p {
            color: var(--text-secondary);
            line-height: 1.8;
            margin-bottom: var(--spacing-md);
        }
        
        .legal-content ul {
            color: var(--text-secondary);
            line-height: 1.8;
            margin-left: var(--spacing-lg);
            margin-bottom: var(--spacing-md);
        }
        
        .legal-content ul li {
            margin-bottom: var(--spacing-xs);
            list-style: disc;
        }
        
        .last-updated {
            color: var(--text-secondary);
            font-style: italic;
            margin-bottom: var(--spacing-lg);
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <section class="page-header" style="padding: 120px 0 60px; background: var(--dark-card); margin-top: 70px;">
        <div class="container">
            <div class="section-header">
                <span class="section-tag">Legal</span>
                <h1 class="section-title">Privacy Policy</h1>
                <p class="last-updated">Last Updated: February 1, 2026</p>
            </div>
        </div>
    </section>

    <section class="legal-content">
        <h2>1. Introduction</h2>
        <p>
            At LinkBoostify, we are committed to protecting your privacy and ensuring the security of your personal information. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you use our services.
        </p>

        <h2>2. Information We Collect</h2>
        <p>
            We collect information that you provide directly to us and information that is automatically collected when you use our services.
        </p>

        <h3>2.1 Information You Provide</h3>
        <ul>
            <li><strong>Contact Information:</strong> Name, email address, phone number, and business address</li>
            <li><strong>Account Information:</strong> Username, password, and account preferences</li>
            <li><strong>Business Information:</strong> Company name, website URL, industry, and business goals</li>
            <li><strong>Payment Information:</strong> Billing address and payment method details (processed securely through third-party payment processors)</li>
            <li><strong>Communication Data:</strong> Messages, feedback, and correspondence with our team</li>
        </ul>

        <h3>2.2 Automatically Collected Information</h3>
        <ul>
            <li><strong>Usage Data:</strong> Pages visited, time spent on pages, and navigation patterns</li>
            <li><strong>Device Information:</strong> IP address, browser type, operating system, and device identifiers</li>
            <li><strong>Cookies and Tracking:</strong> We use cookies and similar technologies to enhance user experience</li>
        </ul>

        <h2>3. How We Use Your Information</h2>
        <p>
            We use the collected information for the following purposes:
        </p>
        <ul>
            <li>Provide, maintain, and improve our services</li>
            <li>Process transactions and send related information</li>
            <li>Communicate with you about services, updates, and promotional offers</li>
            <li>Respond to your inquiries and provide customer support</li>
            <li>Analyze usage patterns to enhance user experience</li>
            <li>Detect, prevent, and address technical issues and security threats</li>
            <li>Comply with legal obligations and enforce our terms</li>
        </ul>

        <h2>4. Information Sharing and Disclosure</h2>
        <p>
            We do not sell your personal information. We may share your information in the following circumstances:
        </p>

        <h3>4.1 Service Providers</h3>
        <p>
            We may share information with third-party service providers who perform services on our behalf, such as:
        </p>
        <ul>
            <li>Payment processing companies</li>
            <li>Email service providers</li>
            <li>Analytics providers</li>
            <li>Cloud hosting services</li>
        </ul>

        <h3>4.2 Legal Requirements</h3>
        <p>
            We may disclose your information if required by law or in response to valid legal requests, such as:
        </p>
        <ul>
            <li>Compliance with legal obligations</li>
            <li>Protection of our rights and property</li>
            <li>Prevention of fraud or security issues</li>
            <li>Protection of user safety</li>
        </ul>

        <h3>4.3 Business Transfers</h3>
        <p>
            In the event of a merger, acquisition, or sale of assets, your information may be transferred to the acquiring entity.
        </p>

        <h2>5. Data Security</h2>
        <p>
            We implement appropriate technical and organizational measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction. These measures include:
        </p>
        <ul>
            <li>Encryption of data in transit and at rest</li>
            <li>Regular security assessments and updates</li>
            <li>Access controls and authentication mechanisms</li>
            <li>Employee training on data protection</li>
        </ul>
        <p>
            However, no method of transmission over the internet or electronic storage is 100% secure. While we strive to protect your information, we cannot guarantee absolute security.
        </p>

        <h2>6. Your Rights and Choices</h2>
        <p>
            You have certain rights regarding your personal information:
        </p>

        <h3>6.1 Access and Correction</h3>
        <p>
            You can access and update your account information at any time through your account settings or by contacting us.
        </p>

        <h3>6.2 Data Deletion</h3>
        <p>
            You may request deletion of your personal information, subject to certain legal obligations that may require us to retain certain data.
        </p>

        <h3>6.3 Marketing Communications</h3>
        <p>
            You can opt out of receiving promotional emails by clicking the unsubscribe link in our emails or contacting us directly.
        </p>

        <h3>6.4 Cookies</h3>
        <p>
            You can control cookies through your browser settings. Note that disabling cookies may affect the functionality of our services.
        </p>

        <h2>7. Data Retention</h2>
        <p>
            We retain your personal information for as long as necessary to fulfill the purposes outlined in this Privacy Policy, unless a longer retention period is required or permitted by law.
        </p>

        <h2>8. Children's Privacy</h2>
        <p>
            Our services are not directed to individuals under the age of 18. We do not knowingly collect personal information from children. If we become aware that we have collected information from a child, we will take steps to delete such information.
        </p>

        <h2>9. International Data Transfers</h2>
        <p>
            Your information may be transferred to and processed in countries other than your country of residence. We ensure appropriate safeguards are in place to protect your information in accordance with this Privacy Policy.
        </p>

        <h2>10. Third-Party Links</h2>
        <p>
            Our website may contain links to third-party websites. We are not responsible for the privacy practices of these external sites. We encourage you to review their privacy policies.
        </p>

        <h2>11. Changes to This Privacy Policy</h2>
        <p>
            We may update this Privacy Policy from time to time. We will notify you of any material changes by posting the new Privacy Policy on this page and updating the "Last Updated" date.
        </p>

        <h2>12. Contact Us</h2>
        <p>
            If you have any questions, concerns, or requests regarding this Privacy Policy or our data practices, please contact us at:
        </p>
        <ul>
            <li><strong>Email:</strong> contact@LinkBoostify.com</li>
            <li><strong>Phone:</strong> +971585483125</li>
        </ul>

        <div style="margin-top: var(--spacing-xxl); padding-top: var(--spacing-lg); border-top: 1px solid var(--border-color);">
            <p style="text-align: center;">
                <a href="index.php" class="btn btn-primary">Back to Home</a>
            </p>
        </div>
    </section>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
</body>
</html>
