<?php
/**
 * Service Contact Form Processor
 * Handles AJAX form submissions from service pages
 */

session_start();

require_once 'includes/config.php';
require_once 'includes/functions.php';

ob_start(); // Start output buffering
header('Content-Type: application/json');
ini_set('display_errors', 0);
error_reporting(0);

// Check if request is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

// Sanitize and validate inputs
$project_type = sanitizeInput($_POST['project_type'] ?? '');
$budget = sanitizeInput($_POST['budget'] ?? '');
$referral = sanitizeInput($_POST['referral'] ?? '');
$first_name = sanitizeInput($_POST['first_name'] ?? '');
$last_name = sanitizeInput($_POST['last_name'] ?? '');
$mobile = sanitizeInput($_POST['mobile'] ?? '');
$email = sanitizeInput($_POST['email'] ?? '');
$message = sanitizeInput($_POST['message'] ?? '');

// Validation
if (empty($first_name) || empty($last_name) || empty($email) || empty($mobile)) {
    echo json_encode(['success' => false, 'message' => 'Please fill all required fields']);
    exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['success' => false, 'message' => 'Please enter a valid email address']);
    exit;
}

try {
    // Insert into database
    $stmt = $conn->prepare("INSERT INTO contact_submissions (name, email, subject, message, status, created_at) VALUES (?, ?, ?, ?, 'new', NOW())");
    
    $full_name = $first_name . ' ' . $last_name;
    $subject = "Service Inquiry: " . $project_type . " (Budget: " . $budget . ")";
    $full_message = "Project Type: " . $project_type . "\n";
    $full_message .= "Budget Range: " . $budget . "\n";
    $full_message .= "Referral Source: " . $referral . "\n";
    $full_message .= "Mobile: " . $mobile . "\n\n";
    $full_message .= "Message:\n" . $message;
    
    $stmt->execute([$full_name, $email, $subject, $full_message]);
    
    // Send email notification to admin
    $to = SITE_EMAIL;
    $email_subject = "New Service Inquiry: " . $project_type;
    $email_body = "
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: linear-gradient(135deg, #FF6B35 0%, #FF8C42 100%); color: white; padding: 20px; border-radius: 8px 8px 0 0; }
            .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 8px 8px; }
            .field { margin-bottom: 15px; }
            .label { font-weight: bold; color: #FF6B35; }
            .value { margin-top: 5px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h2>🎯 New Service Inquiry</h2>
            </div>
            <div class='content'>
                <div class='field'>
                    <div class='label'>Service Type:</div>
                    <div class='value'>{$project_type}</div>
                </div>
                
                <div class='field'>
                    <div class='label'>Budget Range:</div>
                    <div class='value'>{$budget}</div>
                </div>
                
                <div class='field'>
                    <div class='label'>Client Name:</div>
                    <div class='value'>{$full_name}</div>
                </div>
                
                <div class='field'>
                    <div class='label'>Email:</div>
                    <div class='value'><a href='mailto:{$email}'>{$email}</a></div>
                </div>
                
                <div class='field'>
                    <div class='label'>Mobile:</div>
                    <div class='value'>{$mobile}</div>
                </div>
                
                <div class='field'>
                    <div class='label'>How they found us:</div>
                    <div class='value'>{$referral}</div>
                </div>
                
                <div class='field'>
                    <div class='label'>Message:</div>
                    <div class='value'>" . nl2br($message) . "</div>
                </div>
                
                <hr style='margin: 30px 0; border: none; border-top: 1px solid #ddd;'>
                
                <p style='color: #666; font-size: 14px;'>
                    This inquiry was submitted from the {$project_type} service page.
                    <br>Please respond within 24 hours for best conversion rates.
                </p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    $headers = "From: " . SITE_NAME . " <" . SITE_EMAIL . ">\r\n";
    $headers .= "Reply-To: " . $email . "\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
    
    @mail($to, $email_subject, $email_body, $headers);
    
    // Clear any previous output (warnings etc) to ensure valid JSON
    ob_clean();
    
    // Success response
    echo json_encode([
        'success' => true, 
        'message' => 'Thank you! We\'ll get back to you within 24 hours.'
    ]);
    
} catch(PDOException $e) {
    ob_clean();
    echo json_encode([
        'success' => false, 
        'message' => 'Database error. Please try again or contact us directly.'
    ]);
}
?>
