<?php
// router.php for local development server
$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

// Serve existing files directly
if (file_exists(__DIR__ . $uri) && !is_dir(__DIR__ . $uri)) {
    return false;
}

// Serve existing directories with index.php
if (is_dir(__DIR__ . $uri) && file_exists(__DIR__ . $uri . '/index.php')) {
    include __DIR__ . $uri . '/index.php';
    return;
}

// Route: /blog/{slug}
if (preg_match('#^/blog/([a-zA-Z0-9-]+)$#', $uri, $matches)) {
    $_GET['slug'] = $matches[1];
    include 'blog-detail.php';
    return;
}

// 404 Not Found
http_response_code(404);
echo "404 Not Found";
?>
