<?php
session_start();
require_once 'includes/config.php';
require_once 'includes/functions.php';

$page_title = "Our Services - LinkBoostify";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    
    <?php include 'includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <section class="page-header" style="padding: 120px 0 60px; background: var(--dark-bg); margin-top: 70px;">
        <div class="container">
            <div class="section-header">
                <span class="section-tag-orange">WHAT WE DO</span>
                <h1 class="section-title">Link Building Services</h1>
                <p style="color: var(--text-secondary); max-width: 700px; margin: 0 auto;">
                    Professional backlink building services designed to boost your search rankings, drive organic traffic, and establish your website's authority.
                </p>
            </div>
        </div>
    </section>

    <!-- Services Grid matching Index style -->
    <section class="services-section" style="background: transparent;">
        <div class="container">
            <div class="services-cards-grid" style="grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));">
                <!-- Guest Posting Service -->
                <div class="service-process-card">
                    <div class="service-icon-box"><i class="fas fa-newspaper"></i></div>
                    <h3>Guest Posting</h3>
                    <p>Get your content published on high-authority websites in your niche. Build quality backlinks while establishing your brand as an industry authority.</p>
                    <a href="guest-posting.php" class="read-more-link">Read More <i class="fas fa-arrow-right"></i></a>
                </div>

                <!-- Link Insertion Service -->
                <div class="service-process-card">
                    <div class="service-icon-box"><i class="fas fa-link"></i></div>
                    <h3>Link Insertion</h3>
                    <p>Strategic placement of your links in existing high-ranking content. Secure contextual backlinks that pass maximum authority and drive targeted traffic.</p>
                    <a href="link-insertion.php" class="read-more-link">Read More <i class="fas fa-arrow-right"></i></a>
                </div>

                <!-- Wikipedia Backlinks -->
                <div class="service-process-card">
                    <div class="service-icon-box"><i class="fab fa-wikipedia-w"></i></div>
                    <h3>Wikipedia Backlinks</h3>
                    <p>Secure valuable backlinks from Wikipedia, one of the most trusted sources online. Boost your credibility and domain authority with expert Wikipedia link building.</p>
                    <a href="wikipedia-backlinks.php" class="read-more-link">Read More <i class="fas fa-arrow-right"></i></a>
                </div>

                <!-- PBN Backlinks -->
                <div class="service-process-card">
                    <div class="service-icon-box"><i class="fas fa-network-wired"></i></div>
                    <h3>PBN Backlinks</h3>
                    <p>Leverage our premium Private Blog Network for powerful, high-authority backlinks. Safe, effective, and designed to boost your rankings quickly and sustainably.</p>
                    <a href="pbn-backlinks.php" class="read-more-link">Read More <i class="fas fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
    </section>

    <?php 
    // Add service contact form
    $form_service_name = 'Guest Posting'; // Default selection
    include 'includes/service-contact-form.php'; 
    ?>

    <?php include 'includes/footer.php'; ?>
    <script src="assets/js/main.js"></script>
</body>
</html>
