<?php
// Database Setup Script
// Run this file once to create the database and tables

$host = 'localhost';
$user = 'root';
$pass = '';
$dbname = 'linkboostify';

try {
    // Connect without database first
    $conn = new PDO("mysql:host=$host", $user, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Create database
    $conn->exec("CREATE DATABASE IF NOT EXISTS `$dbname` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    echo "✓ Database created successfully<br>";
    
    // Use the database
    $conn->exec("USE `$dbname`");
    
    // Create blogs table
    $conn->exec("CREATE TABLE IF NOT EXISTS `blogs` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `title` varchar(255) NOT NULL,
        `slug` varchar(255) NOT NULL,
        `excerpt` text NOT NULL,
        `content` longtext NOT NULL,
        `image` varchar(255) DEFAULT NULL,
        `category` varchar(100) DEFAULT NULL,
        `status` enum('draft','published') DEFAULT 'draft',
        `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        UNIQUE KEY `slug` (`slug`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    echo "✓ Blogs table created successfully<br>";
    
    // Create portfolio table
    $conn->exec("CREATE TABLE IF NOT EXISTS `portfolio` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `title` varchar(255) NOT NULL,
        `description` text,
        `image` varchar(255) DEFAULT NULL,
        `category` varchar(100) DEFAULT NULL,
        `client` varchar(100) DEFAULT NULL,
        `url` varchar(255) DEFAULT NULL,
        `status` enum('active','inactive') DEFAULT 'active',
        `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    echo "✓ Portfolio table created successfully<br>";
    
    // Create admin users table
    $conn->exec("CREATE TABLE IF NOT EXISTS `admin_users` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `username` varchar(100) NOT NULL,
        `email` varchar(255) NOT NULL,
        `password` varchar(255) NOT NULL,
        `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        UNIQUE KEY `username` (`username`),
        UNIQUE KEY `email` (`email`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    echo "✓ Admin users table created successfully<br>";
    
    // Create contact submissions table
    $conn->exec("CREATE TABLE IF NOT EXISTS `contact_submissions` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(255) NOT NULL,
        `email` varchar(255) NOT NULL,
        `subject` varchar(255) NOT NULL,
        `message` text NOT NULL,
        `status` enum('new','read','replied') DEFAULT 'new',
        `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    echo "✓ Contact submissions table created successfully<br>";
    
    // Insert default admin user (username: admin, password: admin123)
    $hashedPassword = password_hash('admin123', PASSWORD_DEFAULT);
    $stmt = $conn->prepare("INSERT IGNORE INTO admin_users (username, email, password) VALUES (?, ?, ?)");
    $stmt->execute(['admin', 'admin@linkboostify.com', $hashedPassword]);
    echo "✓ Default admin user created (username: admin, password: admin123)<br>";
    
    // Insert sample blog post
    $stmt = $conn->prepare("INSERT IGNORE INTO blogs (id, title, slug, excerpt, content, image, category, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
        1,
        '10 Essential SEO Tips for 2024',
        '10-essential-seo-tips-2024',
        'Discover the most effective SEO strategies to boost your website rankings in 2024.',
        '<h2>Introduction</h2><p>Search Engine Optimization continues to evolve. Here are the top 10 tips to stay ahead...</p>',
        'assets/images/blog/seo-tips.jpg',
        'SEO',
        'published'
    ]);
    echo "✓ Sample blog post created<br>";
    
    echo "<br><strong>✅ Database setup completed successfully!</strong><br><br>";
    echo "<strong>Admin Login Details:</strong><br>";
    echo "URL: <a href='admin-boostify-90/login.php'>admin-boostify-90/login.php</a><br>";
    echo "Username: admin<br>";
    echo "Password: admin123<br><br>";
    echo "<strong>⚠️ IMPORTANT: Delete this setup.php file after setup is complete!</strong>";
    
} catch(PDOException $e) {
    echo "❌ Error: " . $e->getMessage();
}
?>
