<?php
$page_title = "Terms and Conditions - LinkBoostify";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    
    <?php include 'includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        .legal-content {
            max-width: 900px;
            margin: 0 auto;
            padding: var(--spacing-xxl) var(--spacing-md);
        }
        
        .legal-content h2 {
            font-size: 28px;
            margin-top: var(--spacing-xl);
            margin-bottom: var(--spacing-md);
            color: var(--text-primary);
        }
        
        .legal-content h3 {
            font-size: 22px;
            margin-top: var(--spacing-lg);
            margin-bottom: var(--spacing-sm);
            color: var(--primary-color);
        }
        
        .legal-content p {
            color: var(--text-secondary);
            line-height: 1.8;
            margin-bottom: var(--spacing-md);
        }
        
        .legal-content ul {
            color: var(--text-secondary);
            line-height: 1.8;
            margin-left: var(--spacing-lg);
            margin-bottom: var(--spacing-md);
        }
        
        .legal-content ul li {
            margin-bottom: var(--spacing-xs);
            list-style: disc;
        }
        
        .last-updated {
            color: var(--text-secondary);
            font-style: italic;
            margin-bottom: var(--spacing-lg);
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <section class="page-header" style="padding: 120px 0 60px; background: var(--dark-card); margin-top: 70px;">
        <div class="container">
            <div class="section-header">
                <span class="section-tag">Legal</span>
                <h1 class="section-title">Terms and Conditions</h1>
                <p class="last-updated">Last Updated: February 1, 2026</p>
            </div>
        </div>
    </section>

    <section class="legal-content">
        <h2>1. Acceptance of Terms</h2>
        <p>
            By accessing and using LinkBoostify's services, you accept and agree to be bound by the terms and provisions of this agreement. If you do not agree to abide by the above, please do not use this service.
        </p>

        <h2>2. Description of Service</h2>
        <p>
            LinkBoostify provides link building, SEO optimization, content marketing, and related digital marketing services. We reserve the right to modify, suspend, or discontinue any aspect of our services at any time without prior notice.
        </p>

        <h3>2.1 Service Scope</h3>
        <ul>
            <li>High-quality backlink building from authoritative sources</li>
            <li>SEO optimization and consultation</li>
            <li>Content creation and marketing</li>
            <li>Guest posting services</li>
            <li>Digital marketing strategy development</li>
        </ul>

        <h2>3. User Responsibilities</h2>
        <p>
            As a user of our services, you agree to:
        </p>
        <ul>
            <li>Provide accurate and complete information when requested</li>
            <li>Maintain the confidentiality of your account credentials</li>
            <li>Use our services in compliance with all applicable laws and regulations</li>
            <li>Not engage in any activity that could harm our reputation or services</li>
            <li>Not use our services for any illegal or unauthorized purpose</li>
        </ul>

        <h2>4. Payment Terms</h2>
        <p>
            All services are subject to the pricing and payment terms agreed upon at the time of purchase. Payment must be made in full before service delivery unless otherwise agreed in writing.
        </p>

        <h3>4.1 Refund Policy</h3>
        <p>
            Refunds are handled on a case-by-case basis. If you are not satisfied with our services, please contact us within 14 days of service delivery to discuss potential remedies.
        </p>

        <h2>5. Intellectual Property</h2>
        <p>
            All content, trademarks, and data on this website, including but not limited to software, databases, text, graphics, icons, and hyperlinks, are the property of LinkBoostify and are protected by applicable copyright and trademark laws.
        </p>

        <h2>6. Service Guarantees and Limitations</h2>
        <p>
            While we strive to deliver high-quality results, we cannot guarantee specific rankings, traffic increases, or business outcomes. SEO and link building results depend on numerous factors beyond our control, including search engine algorithm changes and competitor activities.
        </p>

        <h3>6.1 No Guarantees</h3>
        <ul>
            <li>We do not guarantee specific search engine rankings</li>
            <li>Results may vary based on industry, competition, and other factors</li>
            <li>Timeline estimates are approximate and not guaranteed</li>
            <li>Third-party platform policies may affect service delivery</li>
        </ul>

        <h2>7. Confidentiality</h2>
        <p>
            We respect the confidentiality of your business information and will not disclose any proprietary information to third parties without your consent, except as required by law.
        </p>

        <h2>8. Limitation of Liability</h2>
        <p>
            LinkBoostify shall not be liable for any indirect, incidental, special, consequential, or punitive damages resulting from your use or inability to use our services. Our total liability shall not exceed the amount paid by you for the specific service in question.
        </p>

        <h2>9. Indemnification</h2>
        <p>
            You agree to indemnify and hold LinkBoostify harmless from any claims, damages, losses, liabilities, and expenses arising from your use of our services or violation of these terms.
        </p>

        <h2>10. Termination</h2>
        <p>
            Either party may terminate services with written notice. Upon termination, you remain responsible for any outstanding payments for services rendered prior to termination.
        </p>

        <h2>11. Changes to Terms</h2>
        <p>
            We reserve the right to modify these terms at any time. Changes will be effective immediately upon posting to our website. Your continued use of our services after changes constitutes acceptance of the modified terms.
        </p>

        <h2>12. Governing Law</h2>
        <p>
            These terms shall be governed by and construed in accordance with applicable laws. Any disputes arising from these terms or our services shall be resolved through binding arbitration.
        </p>

        <h2>13. Contact Information</h2>
        <p>
            If you have any questions about these Terms and Conditions, please contact us at:
        </p>
        <ul>
            <li>Email: contact@LinkBoostify.com</li>
            <li>Phone: +971585483125</li>
        </ul>

        <div style="margin-top: var(--spacing-xxl); padding-top: var(--spacing-lg); border-top: 1px solid var(--border-color);">
            <p style="text-align: center;">
                <a href="index.php" class="btn btn-primary">Back to Home</a>
            </p>
        </div>
    </section>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/main.js"></script>
</body>
</html>
