<?php
require_once 'includes/config.php';

echo "<h2>Database Connection Test</h2>";

echo "<strong>Host:</strong> " . DB_HOST . "<br>";
echo "<strong>User:</strong> " . DB_USER . "<br>";
echo "<strong>DB Name:</strong> " . DB_NAME . "<br>";

echo "<hr>";

if ($conn) {
    echo "<h3 style='color: green;'>✅ Connected Successfully!</h3>";
    echo "Client Version: " . $conn->getAttribute(PDO::ATTR_CLIENT_VERSION) . "<br>";
    echo "Server Version: " . $conn->getAttribute(PDO::ATTR_SERVER_VERSION) . "<br>";
} else {
    echo "<h3 style='color: red;'>❌ Connection Failed</h3>";
    echo "Attempting raw connection to get error details...<br><br>";
    
    try {
        $test_conn = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
        $test_conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        echo "Raw connection worked (This is strange if the main one failed).";
    } catch(PDOException $e) {
        echo "<strong>Error Message:</strong> " . $e->getMessage();
    }
}
?>
