<?php
require_once 'includes/config.php';

try {
    // Add excerpt column
    $conn->exec("ALTER TABLE blogs ADD COLUMN IF NOT EXISTS excerpt TEXT AFTER slug");
    echo "Added excerpt column.\n";
    
    // Add updated_at if missing
    $conn->exec("ALTER TABLE blogs ADD COLUMN IF NOT EXISTS updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP AFTER created_at");
    echo "Added updated_at column.\n";
    
    echo "Blogs table updated successfully.";
} catch(PDOException $e) {
    if ($e->getCode() == '42S21') {
        echo "Columns already exist.";
    } else {
        // Fallback for older MySQL (no IF NOT EXISTS in ALTER)
        try {
             $conn->exec("ALTER TABLE blogs ADD COLUMN excerpt TEXT AFTER slug");
             echo "Added excerpt (fallback).\n";
        } catch(Exception $ex) {}
        
        try {
             $conn->exec("ALTER TABLE blogs ADD COLUMN updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP AFTER created_at");
             echo "Added updated_at (fallback).\n";
        } catch(Exception $ex) {}
    }
}
?>
