<?php
require_once 'includes/config.php';

try {
    // Add subject column if not exists
    $conn->exec("ALTER TABLE contact_submissions ADD COLUMN IF NOT EXISTS subject VARCHAR(255) NOT NULL DEFAULT '' AFTER email");
    echo "Added subject column.\n";
    
    // Add status column if not exists
    $conn->exec("ALTER TABLE contact_submissions ADD COLUMN IF NOT EXISTS status ENUM('new','read','replied') DEFAULT 'new' AFTER message");
    echo "Added status column.\n";
    
    echo "Database updated successfully.";
} catch(PDOException $e) {
    // Handle older MySQL versions that don't support IF NOT EXISTS in ALTER TABLE
    // by ignoring "Duplicate column" error (Code 42S21)
    if ($e->getCode() == '42S21') {
        echo "Columns already exist (or partial update).";
    } else {
        // Fallback: Try adding one by one without IF NOT EXISTS if syntax failed (MariaDB 10.2+ supports it)
        try {
             $conn->exec("ALTER TABLE contact_submissions ADD COLUMN subject VARCHAR(255) NOT NULL DEFAULT '' AFTER email");
             echo "Added subject (fallback).\n";
        } catch(Exception $ex) {}
        
        try {
             $conn->exec("ALTER TABLE contact_submissions ADD COLUMN status ENUM('new','read','replied') DEFAULT 'new' AFTER message");
             echo "Added status (fallback).\n";
        } catch(Exception $ex) {}
        
        echo "Update attempt finished.";
    }
}
?>
