<?php
session_start();
require_once 'includes/config.php';
require_once 'includes/functions.php';

$page_title = "Wikipedia Backlinks Service - The Ultimate Authority Link | LinkBoostify";
$page_description = "Establish unbeatable trust and authority. Get your brand cited on Wikipedia, the world's most trusted encyclopedia, with our expert link building service.";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <meta name="description" content="<?php echo $page_description; ?>">
    
    <?php include 'includes/favicon-meta.php'; ?>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <!-- Hero Section -->
    <section class="hero-padding" style="background: var(--dark-bg); margin-top: 70px;">
        <div class="container">
            <div class="hero-grid">
                <div>
                    <span style="color: var(--primary-color); font-size: 14px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; display: flex; align-items: center; gap: 8px; margin-bottom: 20px;">
                        <i class="fas fa-circle" style="font-size: 8px;"></i> ULTIMATE AUTHORITY
                    </span>
                    
                    <h1 style="font-size: 56px; font-weight: 800; line-height: 1.1; margin-bottom: 30px; color: var(--text-primary);">
                        Build Trust with <span style="color: var(--primary-color);">Wikipedia Links</span>
                    </h1>
                    
                    <p style="color: var(--text-secondary); font-size: 18px; line-height: 1.8; margin-bottom: 30px;">
                        Secure a citation on the world's most trusted website. Boost your brand's credibility, gain referral traffic, and signal ultimate authority to Google.
                    </p>
                    
                    <div style="display: flex; gap: 15px; margin-bottom: 40px;">
                        <a href="contact-us.php" class="btn btn-primary btn-large">
                            Check Eligibility <i class="fas fa-arrow-right"></i>
                        </a>
                        <a href="#process" class="btn btn-secondary btn-large">
                            Learn More
                        </a>
                    </div>
                    
                    <!-- Stats -->
                    <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 30px; padding-top: 30px; border-top: 1px solid rgba(255,255,255,0.1);">
                        <div>
                            <h3 style="font-size: 32px; font-weight: 800; color: var(--primary-color); margin-bottom: 5px;">DA 98</h3>
                            <p style="color: var(--text-secondary); font-size: 14px;">Domain Authority</p>
                        </div>
                        <div>
                            <h3 style="font-size: 32px; font-weight: 800; color: var(--primary-color); margin-bottom: 5px;">Top 10</h3>
                            <p style="color: var(--text-secondary); font-size: 14px;">Global Site Rank</p>
                        </div>
                        <div>
                            <h3 style="font-size: 32px; font-weight: 800; color: var(--primary-color); margin-bottom: 5px;">100%</h3>
                            <p style="color: var(--text-secondary); font-size: 14px;">Safe & Compliant</p>
                        </div>
                    </div>
                </div>
                
                <div class="image-anime">
                    <img src="assets/images/wiki-hero.png" alt="Wikipedia Backlinks" style="width: 100%; height: auto; border-radius: 12px; box-shadow: 0 0 40px rgba(255, 107, 53, 0.1);" loading="lazy" decoding="async">
                </div>
            </div>
        </div>
    </section>

    <!-- Why Wikipedia Matters -->
    <section style="padding: var(--spacing-xxl) 0; background: var(--dark-card);">
        <div class="container">
            <div style="max-width: 900px; margin: 0 auto; text-align: center;">
                <h2 class="section-title" style="margin-bottom: 30px;">Why <span style="color: var(--primary-color);">Wikipedia Matters?</span></h2>
                <div class="orange-bracket-box">
                    <p style="color: var(--text-secondary); font-size: 18px; line-height: 1.8; margin: 0;">
                        Wikipedia is the gold standard of online information. While links are technically nofollow, they provide immense value through referral traffic, brand credibility, and indirect SEO benefits. Being cited on Wikipedia signals to search engines (and humans) that your website is a credible, notable, and authoritative source of information.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Detailed Process Section -->
    <section id="process" style="padding: var(--spacing-xxl) 0; background: var(--dark-bg);">
        <div class="container">
            <div class="section-header" style="text-align: center; margin-bottom: 60px;">
                <h2 class="section-title">Our Wikipedia <span style="color: var(--primary-color);">Process</span></h2>
                <p style="color: var(--text-secondary); max-width: 700px; margin: 20px auto 0;">
                    A careful, guideline-compliant approach to securing citations
                </p>
            </div>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: start;">
                 <!-- Left Side: Image -->
                <div class="image-anime">
                    <img src="assets/images/wiki-process.png" alt="Wikipedia Process" style="width: 100%; height: auto; border-radius: 12px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);" loading="lazy" decoding="async">
                </div>
                
                <!-- Right Side: Process Steps -->
                <div style="display: flex; flex-direction: column; gap: 20px;">
                    <div class="numbered-card">
                        <h3>Eligibility Check</h3>
                        <span class="card-number">01</span>
                    </div>
                    
                    <div class="numbered-card">
                        <h3>Citation Research</h3>
                        <span class="card-number">02</span>
                    </div>
                    
                    <div class="numbered-card">
                        <h3>Content Creation</h3>
                        <span class="card-number">03</span>
                    </div>
                    
                    <div class="numbered-card">
                        <h3>Strategic Placement</h3>
                        <span class="card-number">04</span>
                    </div>
                    
                    <div class="numbered-card">
                        <h3>Monitoring & Maintenance</h3>
                        <span class="card-number">05</span>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Benefits Section -->
    <section style="padding: var(--spacing-xxl) 0; background: var(--dark-card);">
        <div class="container">
            <div class="section-header" style="text-align: center; margin-bottom: 60px;">
                <h2 class="section-title">Benefits of <span style="color: var(--primary-color);">Wikipedia Links</span></h2>
            </div>
            
            <div class="about-grid" style="grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 30px;">
                <div class="modern-benefit-card text-center">
                    <div class="benefit-icon-wrapper mx-auto">
                        <i class="fas fa-certificate"></i>
                    </div>
                    <h3>Ultimate Authority</h3>
                    <p>A citation from a DA 98+ site is the ultimate vote of confidence for your brand's credibility.</p>
                </div>
                
                <div class="modern-benefit-card text-center">
                    <div class="benefit-icon-wrapper mx-auto">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3>Referral Traffic</h3>
                    <p>Wikipedia pages rank for millions of keywords, driving highly relevant traffic to cited sources.</p>
                </div>
                
                <div class="modern-benefit-card text-center">
                    <div class="benefit-icon-wrapper mx-auto">
                        <i class="fas fa-trophy"></i>
                    </div>
                    <h3>Brand Trust</h3>
                    <p>Customers and partners trust brands that are referenced in the world's encyclopedia.</p>
                </div>
                
                <div class="modern-benefit-card text-center">
                    <div class="benefit-icon-wrapper mx-auto">
                        <i class="fas fa-link"></i>
                    </div>
                    <h3>Link Magnet</h3>
                    <p>Wikipedia citations often lead to secondary backlinks as other writers research your topic.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Requirements & CTA -->
    <section style="padding: var(--spacing-xxl) 0; background: var(--dark-bg);">
        <div class="container">
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 80px; align-items: start;">
                <div>
                    <h2 class="section-title" style="margin-bottom: 30px;">Important <span style="color: var(--primary-color);">Requirements</span></h2>
                    <p style="color: var(--text-secondary); font-size: 18px; line-height: 1.8; margin-bottom: 30px;">
                        Wikipedia has strict notability and conflict of interest guidelines. Not every site qualifies. We work best with:
                    </p>
                    
                    <div style="display: flex; flex-direction: column; gap: 15px;">
                        <div style="display: flex; align-items: center; gap: 15px;">
                            <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                            <span style="color: var(--text-primary); font-size: 16px;">Established brands with history</span>
                        </div>
                        
                        <div style="display: flex; align-items: center; gap: 15px;">
                            <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                            <span style="color: var(--text-primary); font-size: 16px;">Sites with existing reputable press coverage</span>
                        </div>
                        
                        <div style="display: flex; align-items: center; gap: 15px;">
                            <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                            <span style="color: var(--text-primary); font-size: 16px;">Unique, non-promotional content resources</span>
                        </div>
                        
                        <div style="display: flex; align-items: center; gap: 15px;">
                            <i class="fas fa-check-circle" style="color: var(--primary-color); font-size: 20px;"></i>
                            <span style="color: var(--text-primary); font-size: 16px;">Academic or research-based organizations</span>
                        </div>
                    </div>
                </div>
                
                <div style="background: rgba(255, 107, 53, 0.05); padding: 50px; border-radius: 12px; border: 1px solid rgba(255, 107, 53, 0.2);">
                    <div style="text-align: center; margin-bottom: 30px;">
                        <i class="fas fa-shield-alt" style="font-size: 48px; color: var(--primary-color); margin-bottom: 20px;"></i>
                        <h3 style="font-size: 28px; margin-bottom: 15px; color: var(--text-primary);">Is Your Site Eligible?</h3>
                        <p style="color: var(--text-secondary); line-height: 1.7;">
                            Don't risk your reputation with spammy edits. Let our experts evaluating your site's notability for free.
                        </p>
                    </div>
                    
                    <a href="contact-us.php" class="btn btn-primary btn-large" style="width: 100%; justify-content: center;">
                        Get Free Evaluation <i class="fas fa-arrow-right"></i>
                    </a>
                    
                    <p style="text-align: center; margin-top: 20px; font-size: 14px; color: var(--text-muted);">
                        <i class="fas fa-lock"></i> 100% Risk-Free Assessment
                    </p>
                </div>
            </div>
        </div>
    </section>

    <?php 
    $form_service_name = 'Wikipedia Backlinks';
    include 'includes/service-contact-form.php'; 
    ?>

    <?php include 'includes/footer.php'; ?>
    <script src="assets/js/main.js"></script>
</body>
</html>

